/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.Objects;
import java.util.function.Consumer;
import mods.railcraft.Translations;
import mods.railcraft.api.item.Filter;
import mods.railcraft.api.item.MinecartFactory;
import mods.railcraft.world.item.CartItem;
import mods.railcraft.world.item.component.LocomotiveColorComponent;
import mods.railcraft.world.item.component.LocomotiveOwnerComponent;
import mods.railcraft.world.item.component.LocomotiveWhistlePitchComponent;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.NameAndId;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class LocomotiveItem
extends CartItem
implements Filter {
    public LocomotiveItem(MinecartFactory minecartPlacer, Item.Properties properties) {
        super(minecartPlacer, properties);
    }

    @Override
    public boolean matches(ItemStack matcher, ItemStack target) {
        return target.is((Item)this) && LocomotiveItem.getColor(matcher).equals(LocomotiveItem.getColor(target));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        LocomotiveWhistlePitchComponent whistlePitch;
        LocomotiveColorComponent color;
        NameAndId owner = LocomotiveItem.getOwner(stack);
        if (owner != null && StringUtils.isNotBlank((CharSequence)owner.name())) {
            tooltipAdder.accept((Component)Component.translatable((String)Translations.Tips.LOCOMOTIVE_ITEM_OWNER).withStyle(ChatFormatting.AQUA).append(CommonComponents.SPACE).append((Component)Component.literal((String)owner.name()).withStyle(ChatFormatting.GRAY)));
        }
        if ((color = (LocomotiveColorComponent)stack.get(RailcraftDataComponents.LOCOMOTIVE_COLOR)) != null) {
            color.addToTooltip(context, tooltipAdder, flag, (DataComponentGetter)this.components());
        }
        if ((whistlePitch = (LocomotiveWhistlePitchComponent)stack.get(RailcraftDataComponents.LOCOMOTIVE_WHISTLE_PITCH)) != null) {
            whistlePitch.addToTooltip(context, tooltipAdder, flag, (DataComponentGetter)this.components());
        }
    }

    public static void setItemColorData(ItemStack stack, DyeColor primaryColor, DyeColor secondaryColor) {
        stack.set(RailcraftDataComponents.LOCOMOTIVE_COLOR, (Object)new LocomotiveColorComponent(primaryColor, secondaryColor));
    }

    public static void setItemWhistleData(ItemStack stack, float whistlePitch) {
        stack.set(RailcraftDataComponents.LOCOMOTIVE_WHISTLE_PITCH, (Object)new LocomotiveWhistlePitchComponent(whistlePitch));
    }

    public static void setOwnerData(ItemStack stack, NameAndId owner) {
        stack.set(RailcraftDataComponents.LOCOMOTIVE_OWNER, (Object)new LocomotiveOwnerComponent(owner));
    }

    @Nullable
    public static NameAndId getOwner(ItemStack stack) {
        if (stack.has(RailcraftDataComponents.LOCOMOTIVE_OWNER)) {
            return Objects.requireNonNull((LocomotiveOwnerComponent)stack.get(RailcraftDataComponents.LOCOMOTIVE_OWNER)).owner();
        }
        return null;
    }

    public static LocomotiveColorComponent getColor(ItemStack stack) {
        if (stack.has(RailcraftDataComponents.LOCOMOTIVE_COLOR)) {
            return Objects.requireNonNull((LocomotiveColorComponent)stack.get(RailcraftDataComponents.LOCOMOTIVE_COLOR));
        }
        throw new IllegalArgumentException("locomotive_color component not found");
    }
}

