/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.function.Consumer;
import mods.railcraft.Translations;
import mods.railcraft.api.signal.entity.SignalControllerEntity;
import mods.railcraft.api.signal.entity.SignalReceiverEntity;
import mods.railcraft.world.item.PairingToolItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.jetbrains.annotations.Nullable;

public class SignalTunerItem
extends PairingToolItem<SignalControllerEntity, SignalReceiverEntity> {
    public SignalTunerItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        tooltipAdder.accept((Component)Component.translatable((String)Translations.Tips.LINKS_CONTROLLERS_TO_RECEIVERS).withStyle(ChatFormatting.GRAY));
    }

    @Override
    protected Class<SignalControllerEntity> targetType() {
        return SignalControllerEntity.class;
    }

    @Override
    protected Class<SignalReceiverEntity> peerType() {
        return SignalReceiverEntity.class;
    }

    @Override
    protected Component getMessageForState(PairingToolItem.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case PairingToolItem.State.ABANDONED -> Component.translatable((String)Translations.Signal.SIGNAL_TUNER_ABANDONED).withStyle(ChatFormatting.LIGHT_PURPLE);
            case PairingToolItem.State.LOST_TARGET -> Component.translatable((String)Translations.Signal.SIGNAL_TUNER_LOST).withStyle(ChatFormatting.RED);
            case PairingToolItem.State.INVALID_TARGET -> Component.translatable((String)Translations.Signal.SIGNAL_TUNER_INVALID_CONTROLLER).withStyle(ChatFormatting.RED);
            case PairingToolItem.State.INVALID_PEER -> Component.translatable((String)Translations.Signal.SIGNAL_TUNER_INVALID_RECEIVER).withStyle(ChatFormatting.RED);
        };
    }

    @Override
    protected void abandon(@Nullable SignalControllerEntity target) {
        if (target != null) {
            target.getSignalController().stopLinking();
        }
    }

    @Override
    protected PairingToolItem.Result begin(SignalControllerEntity target) {
        target.getSignalController().startLinking();
        return PairingToolItem.Result.success((Component)Component.translatable((String)Translations.Signal.SIGNAL_TUNER_BEGIN, (Object[])new Object[]{target.getDisplayName()}).withStyle(ChatFormatting.LIGHT_PURPLE));
    }

    @Override
    protected PairingToolItem.Result complete(SignalControllerEntity target, SignalReceiverEntity peer) {
        boolean success = target.getSignalController().addPeer(peer);
        target.getSignalController().stopLinking();
        return new PairingToolItem.Result(success, (Component)(success ? Component.translatable((String)Translations.Signal.SIGNAL_TUNER_SUCCESS, (Object[])new Object[]{peer.getDisplayName(), target.getDisplayName()}).withStyle(ChatFormatting.GREEN) : Component.translatable((String)Translations.Signal.SIGNAL_TUNER_ALREADY_PAIRED, (Object[])new Object[]{peer.getDisplayName(), target.getDisplayName()}).withStyle(ChatFormatting.RED)));
    }
}

