/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import mods.railcraft.Translations;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.world.level.block.charge.BatterySpecs;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record BatteryComponent(boolean isRechargeable, int capacity, int maxDraw, float loss, int efficiency) implements TooltipProvider
{
    public static final Codec<BatteryComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("isRechargeable").forGetter(BatteryComponent::isRechargeable), (App)Codec.INT.fieldOf("capacity").forGetter(BatteryComponent::capacity), (App)Codec.INT.fieldOf("maxDraw").forGetter(BatteryComponent::maxDraw), (App)Codec.FLOAT.fieldOf("loss").forGetter(BatteryComponent::loss), (App)Codec.INT.fieldOf("efficiency").forGetter(BatteryComponent::efficiency)).apply((Applicative)instance, BatteryComponent::new));
    public static final StreamCodec<FriendlyByteBuf, BatteryComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, BatteryComponent::isRechargeable, (StreamCodec)ByteBufCodecs.INT, BatteryComponent::capacity, (StreamCodec)ByteBufCodecs.INT, BatteryComponent::maxDraw, (StreamCodec)ByteBufCodecs.FLOAT, BatteryComponent::loss, (StreamCodec)ByteBufCodecs.INT, BatteryComponent::efficiency, BatteryComponent::new);

    public static BatteryComponent from(BatterySpecs batterySpecs) {
        ChargeBlock.Spec spec = batterySpecs.buildSpec();
        return new BatteryComponent(spec.storageSpec().initialState().equals((Object)ChargeStorage.State.RECHARGEABLE), spec.storageSpec().capacity() / 1000, spec.storageSpec().maxDraw(), spec.losses(), (int)(spec.storageSpec().efficiency() * 100.0f));
    }

    public void addToTooltip(Item.TooltipContext tooltipContext, Consumer<Component> consumer, TooltipFlag tooltipFlag, DataComponentGetter dataComponentGetter) {
        consumer.accept((Component)Component.translatable((String)(this.isRechargeable ? Translations.Tips.TYPE_RECHARGEABLE : Translations.Tips.TYPE_DISPOSABLE)).withStyle(ChatFormatting.BLUE));
        consumer.accept((Component)Component.translatable((String)Translations.Tips.CAPACITY, (Object[])new Object[]{this.capacity}).withStyle(ChatFormatting.GRAY));
        consumer.accept((Component)Component.translatable((String)Translations.Tips.MAX_DRAW, (Object[])new Object[]{this.maxDraw}).withStyle(ChatFormatting.GRAY));
        consumer.accept((Component)Component.translatable((String)Translations.Tips.LOSS, (Object[])new Object[]{Float.valueOf(this.loss)}).withStyle(ChatFormatting.GRAY));
        consumer.accept((Component)Component.translatable((String)Translations.Tips.EFFICIENCY, (Object[])new Object[]{this.efficiency}).withStyle(ChatFormatting.GRAY));
    }
}

