/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import mods.railcraft.Translations;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record LocomotiveWhistlePitchComponent(float whistlePitch) implements TooltipProvider
{
    public static LocomotiveWhistlePitchComponent NO_WHISTLE = new LocomotiveWhistlePitchComponent(-1.0f);
    public static final Codec<LocomotiveWhistlePitchComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("whistlePitch").forGetter(LocomotiveWhistlePitchComponent::whistlePitch)).apply((Applicative)instance, LocomotiveWhistlePitchComponent::new));
    public static final StreamCodec<FriendlyByteBuf, LocomotiveWhistlePitchComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, LocomotiveWhistlePitchComponent::whistlePitch, LocomotiveWhistlePitchComponent::new);

    public void addToTooltip(Item.TooltipContext tooltipContext, Consumer<Component> consumer, TooltipFlag tooltipFlag, DataComponentGetter dataComponentGetter) {
        if (this.whistlePitch < 0.0f) {
            consumer.accept((Component)Component.translatable((String)Translations.Tips.LOCOMOTIVE_ITEM_NO_WHISTLE).withStyle(ChatFormatting.GRAY));
        } else {
            consumer.accept((Component)Component.translatable((String)Translations.Tips.LOCOMOTIVE_ITEM_WHISTLE).withStyle(ChatFormatting.AQUA).append(CommonComponents.SPACE).append((Component)Component.literal((String)String.format("%.2f", Float.valueOf(this.whistlePitch))).withStyle(ChatFormatting.GRAY)));
        }
    }
}

