/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class CartDisassemblyRecipe
extends CustomRecipe {
    private final Item ingredient;
    private final Item result;
    @Nullable
    private PlacementInfo placementInfo;

    public CartDisassemblyRecipe(Item ingredient, Item result, CraftingBookCategory category) {
        super(category);
        this.ingredient = ingredient;
        this.result = result;
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        boolean ingredientsMatch = false;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack stack = craftingInput.getItem(i);
            if (ingredientsMatch || !stack.is(this.ingredient)) continue;
            ingredientsMatch = true;
        }
        return craftingInput.ingredientCount() == 1 && ingredientsMatch;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return new ItemStack((ItemLike)this.result);
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create((Ingredient)Ingredient.of((ItemLike)this.ingredient));
        }
        return this.placementInfo;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput craftingInput) {
        NonNullList grid = NonNullList.withSize((int)craftingInput.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemStack = craftingInput.getItem(i);
            if (!itemStack.is(this.ingredient)) continue;
            grid.set(i, (Object)new ItemStack((ItemLike)Items.MINECART));
        }
        return grid;
    }
}

