/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mods.railcraft.util.RecipeUtil;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CrusherRecipe
implements Recipe<SingleRecipeInput> {
    private final Ingredient ingredient;
    private final List<CrusherOutput> probabilityOutputs;
    private final int processTime;
    @Nullable
    private PlacementInfo placementInfo;

    public CrusherRecipe(Ingredient ingredient, List<CrusherOutput> probabilityOutputs, int processTime) {
        this.ingredient = ingredient;
        this.probabilityOutputs = probabilityOutputs;
        this.processTime = processTime;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public boolean matches(SingleRecipeInput inventory, Level level) {
        return this.ingredient.test(inventory.getItem(0));
    }

    public ItemStack assemble(SingleRecipeInput inventory, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public List<CrusherOutput> getProbabilityOutputs() {
        return this.probabilityOutputs;
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create((Ingredient)this.ingredient);
        }
        return this.placementInfo;
    }

    public RecipeSerializer<CrusherRecipe> getSerializer() {
        return (RecipeSerializer)RailcraftRecipeSerializers.CRUSHER.get();
    }

    public RecipeType<CrusherRecipe> getType() {
        return (RecipeType)RailcraftRecipeTypes.CRUSHING.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public static class Serializer
    implements RecipeSerializer<CrusherRecipe> {
        private static final MapCodec<CrusherRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)CrusherOutput.CODEC.listOf().fieldOf("outputs").orElse(Collections.emptyList()).forGetter(recipe -> recipe.probabilityOutputs), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("processTime", (Object)200).forGetter(recipe -> recipe.processTime)).apply((Applicative)instance, CrusherRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, CrusherRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<CrusherRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CrusherRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static CrusherRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int tickCost = buffer.readVarInt();
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int size = buffer.readVarInt();
            ArrayList<CrusherOutput> probabilityOutputs = new ArrayList<CrusherOutput>();
            for (int i = 0; i < size; ++i) {
                probabilityOutputs.add(new CrusherOutput((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), buffer.readVarInt(), buffer.readDouble()));
            }
            return new CrusherRecipe(ingredient, probabilityOutputs, tickCost);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, CrusherRecipe recipe) {
            buffer.writeVarInt(recipe.processTime);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            buffer.writeVarInt(recipe.probabilityOutputs.size());
            for (int i = 0; i < recipe.probabilityOutputs.size(); ++i) {
                CrusherOutput item = recipe.probabilityOutputs.get(i);
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)item.output);
                buffer.writeVarInt(item.quantity);
                buffer.writeDouble(item.probability);
            }
        }
    }

    public record CrusherOutput(Ingredient output, int quantity, double probability) {
        private static final Codec<CrusherOutput> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("count", (Object)1).forGetter(recipe -> recipe.quantity), (App)Codec.doubleRange((double)0.0, (double)1.0).fieldOf("probability").forGetter(recipe -> recipe.probability)).apply((Applicative)instance, CrusherOutput::new));

        public ItemStack getOutput() {
            return RecipeUtil.getPreferredStackByMod(this.output.getValues().stream().toList()).copyWithCount(this.quantity);
        }
    }
}

