/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RollingRecipe
implements Recipe<CraftingInput> {
    private final ShapedRecipePattern pattern;
    private final ItemStack result;
    private final int processTime;
    @Nullable
    private PlacementInfo placementInfo;

    public RollingRecipe(ShapedRecipePattern pattern, ItemStack result, int processTime) {
        this.pattern = pattern;
        this.result = result;
        this.processTime = processTime;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    public boolean matches(CraftingInput inventory, Level level) {
        return this.pattern.matches(inventory);
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public ItemStack getResult() {
        return this.result;
    }

    public RecipeSerializer<RollingRecipe> getSerializer() {
        return (RecipeSerializer)RailcraftRecipeSerializers.ROLLING.get();
    }

    public RecipeType<RollingRecipe> getType() {
        return (RecipeType)RailcraftRecipeTypes.ROLLING.get();
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals((List)this.pattern.ingredients());
        }
        return this.placementInfo;
    }

    public boolean isSpecial() {
        return true;
    }

    public List<RecipeDisplay> display() {
        return List.of(new ShapedCraftingRecipeDisplay(this.pattern.width(), this.pattern.height(), this.pattern.ingredients().stream().map(ingredient -> ingredient.map(Ingredient::display).orElse((SlotDisplay)SlotDisplay.Empty.INSTANCE)).toList(), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.result), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(RailcraftItems.MANUAL_ROLLING_MACHINE)));
    }

    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public static class Serializer
    implements RecipeSerializer<RollingRecipe> {
        private static final MapCodec<RollingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("processTime", (Object)100).forGetter(recipe -> recipe.processTime)).apply((Applicative)instance, RollingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, RollingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<RollingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RollingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static RollingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            int processTime = buffer.readVarInt();
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new RollingRecipe(pattern, result, processTime);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, RollingRecipe recipe) {
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
            buffer.writeVarInt(recipe.processTime);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        }
    }
}

