/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RotorRepairRecipe
extends CustomRecipe {
    public static final int REPAIR_PER_BLADE = 2500;
    private static final Ingredient ROTOR = Ingredient.of((ItemLike)((ItemLike)RailcraftItems.TURBINE_ROTOR.get()));
    private static final Ingredient BLADE = Ingredient.of((ItemLike)((ItemLike)RailcraftItems.TURBINE_BLADE.get()));
    @Nullable
    private PlacementInfo placementInfo;

    public RotorRepairRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        if (craftingInput.height() < 2 || craftingInput.width() < 2) {
            return false;
        }
        boolean containsRotor = false;
        boolean containsBlade = false;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack stack = craftingInput.getItem(i);
            if (!containsRotor && ROTOR.test(stack)) {
                containsRotor = true;
            }
            if (containsBlade || !BLADE.test(stack)) continue;
            containsBlade = true;
        }
        return containsRotor && containsBlade;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        ItemStack rotor = IntStream.range(0, craftingInput.size()).mapToObj(arg_0 -> ((CraftingInput)craftingInput).getItem(arg_0)).filter((Predicate<ItemStack>)ROTOR).findFirst().orElse(ItemStack.EMPTY);
        if (rotor.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int numBlades = (int)IntStream.range(0, craftingInput.size()).mapToObj(arg_0 -> ((CraftingInput)craftingInput).getItem(arg_0)).filter((Predicate<ItemStack>)BLADE).count();
        int damage = rotor.getDamageValue();
        if ((damage -= 2500 * numBlades) < 0) {
            damage = 0;
        }
        ItemStack result = rotor.copy();
        result.setDamageValue(damage);
        return result;
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            NonNullList ingredients = NonNullList.create();
            ingredients.add((Object)ROTOR);
            ingredients.add((Object)BLADE);
            this.placementInfo = PlacementInfo.create((List)ingredients);
        }
        return this.placementInfo;
    }

    public RecipeSerializer<RotorRepairRecipe> getSerializer() {
        return (RecipeSerializer)RailcraftRecipeSerializers.ROTOR_REPAIR.get();
    }
}

