/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public abstract class TieRecipe
extends CustomRecipe {
    private final TagKey<Fluid> fluidTag;
    private final ItemStack result;
    @Nullable
    private PlacementInfo placementInfo;

    public TieRecipe(CraftingBookCategory category, TagKey<Fluid> fluidTag, ItemStack result) {
        super(category);
        this.fluidTag = fluidTag;
        this.result = result;
    }

    public final boolean matches(CraftingInput craftingInput, Level level) {
        if (craftingInput.width() != 3 || craftingInput.height() != 2) {
            return false;
        }
        if (!craftingInput.getItem(0).isEmpty() || !craftingInput.getItem(2).isEmpty()) {
            return false;
        }
        ItemStack item = craftingInput.getItem(1);
        if (item.isEmpty()) {
            return false;
        }
        ResourceHandler cap = (ResourceHandler)item.getCapability(Capabilities.Fluid.ITEM, null);
        if (cap == null || !FluidUtil.getStack((ResourceHandler)cap, (int)0).is(this.fluidTag)) {
            return false;
        }
        return this.testIngredient(craftingInput.getItem(3), 0) && this.testIngredient(craftingInput.getItem(4), 1) && this.testIngredient(craftingInput.getItem(5), 2);
    }

    protected abstract boolean testIngredient(ItemStack var1, int var2);

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        ResourceHandler fluidHandler = Objects.requireNonNull((ResourceHandler)craftingInput.getItem(1).getCapability(Capabilities.Fluid.ITEM, null));
        if (fluidHandler.getAmountAsInt(0) >= 1000) {
            return this.result.copy();
        }
        return ItemStack.EMPTY;
    }

    public final NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList remainingItems = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack item = input.getItem(i);
            if (!item.getCraftingRemainder().isEmpty()) {
                remainingItems.set(i, (Object)item.getCraftingRemainder());
                continue;
            }
            ItemAccess itemAccess = ItemAccess.forStack((ItemStack)item);
            ResourceHandler cap = (ResourceHandler)itemAccess.getCapability(Capabilities.Fluid.ITEM);
            if (cap == null) continue;
            try (Transaction tx = Transaction.openRoot();){
                int extracted;
                FluidResource resource = (FluidResource)cap.getResource(0);
                if (!resource.isEmpty() && (extracted = cap.extract((Resource)resource, 1000, (TransactionContext)tx)) == 1000) {
                    tx.commit();
                }
            }
            remainingItems.set(i, (Object)item.copy());
        }
        return remainingItems;
    }
}

