/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.world.level.block.MultiblockBlock;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.SteamTurbineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SteamTurbineBlock
extends MultiblockBlock
implements ChargeBlock {
    public static final Property<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    public static final Property<Boolean> ROTATED = BooleanProperty.create((String)"rotated");
    private static final MapCodec<SteamTurbineBlock> CODEC = SteamTurbineBlock.simpleCodec(SteamTurbineBlock::new);

    public SteamTurbineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(TYPE, (Comparable)((Object)Type.NONE))).setValue(ROTATED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends MultiblockBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, ROTATED});
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new SteamTurbineBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.isClientSide() ? null : SteamTurbineBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.STEAM_TURBINE.get()), SteamTurbineBlockEntity::serverTick);
    }

    @Override
    public Map<Charge, ChargeBlock.Spec> getChargeSpecs(BlockState state, ServerLevel level, BlockPos pos) {
        return ChargeBlock.Spec.make(Charge.distribution, ChargeBlock.ConnectType.BLOCK, 0.0f, new ChargeStorage.Spec(ChargeStorage.State.DISABLED, 225 * ((Double)RailcraftConfig.SERVER.turbinePowerMultiplier.get()).intValue(), 225 * ((Double)RailcraftConfig.SERVER.turbinePowerMultiplier.get()).intValue(), 1.0f));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        Charge.zapEffectProvider().throwSparks(state, level, pos, rand, 50);
    }

    public void tick(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource random) {
        super.tick(blockState, level, blockPos, random);
        this.registerNode(blockState, level, blockPos);
    }

    public void onPlace(BlockState blockState, Level level, BlockPos blockPos, BlockState oldState, boolean moved) {
        super.onPlace(blockState, level, blockPos, oldState, moved);
        if (!blockState.is(oldState.getBlock())) {
            this.registerNode(blockState, (ServerLevel)level, blockPos);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos, Direction direction) {
        return Charge.distribution.network((ServerLevel)level).access(pos).getComparatorOutput();
    }

    public static enum Type implements StringRepresentable
    {
        TOP_LEFT("top_left"),
        TOP_RIGHT("top_right"),
        BOTTOM_LEFT("bottom_left"),
        BOTTOM_RIGHT("bottom_right"),
        WINDOW("window"),
        NONE("none");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

