/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.charge;

import java.util.Collections;
import java.util.Map;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.integrations.jei.JeiSearchable;
import mods.railcraft.util.BoxBuilder;
import mods.railcraft.world.level.block.charge.ChargeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BatteryBlock
extends ChargeBlock
implements JeiSearchable {
    private static final VoxelShape SHAPE = Shapes.create((AABB)BoxBuilder.create().box().raiseCeiling(-0.0625).build());

    public BatteryBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean isInside) {
        super.entityInside(state, level, pos, entity, effectApplier, isInside);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Charge.distribution.network(serverLevel).access(pos).zap(entity, Charge.DamageOrigin.BLOCK, 1.0f);
        }
    }

    protected abstract ChargeBlock.Spec getChargeSpec();

    @Override
    public Map<Charge, ChargeBlock.Spec> getChargeSpecs(BlockState state, ServerLevel level, BlockPos pos) {
        return Collections.singletonMap(Charge.distribution, this.getChargeSpec());
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

