/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.charge;

import mods.railcraft.api.charge.Charge;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ChargeBlock
extends Block
implements mods.railcraft.api.charge.ChargeBlock {
    public ChargeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean isSparking(BlockState state) {
        return true;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.isSparking(state)) {
            Charge.zapEffectProvider().throwSparks(state, level, pos, random, 50);
        }
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.randomTick(state, level, pos, random);
        level.updateNeighbourForOutputSignal(pos, (Block)this);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        this.registerNode(state, level, pos);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!state.is(oldState.getBlock())) {
            this.registerNode(state, (ServerLevel)level, pos);
        }
    }

    protected void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean movedByPiston) {
        super.affectNeighborsAfterRemoval(state, level, pos, movedByPiston);
        this.deregisterNode(level, pos);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos, Direction direction) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return Charge.distribution.network(serverLevel).access(pos).getComparatorOutput();
        }
        return 0;
    }
}

