/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import mods.railcraft.particle.ChimneyParticleOptions;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ChimneyBlockEntity
extends RailcraftBlockEntity {
    private static final int SNOW_MELT_INTERVAL = 32;
    private int tick;
    private int color = DyeColor.BLACK.getFireworkColor();

    public ChimneyBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.SMOKER.get(), blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, ChimneyBlockEntity blockEntity) {
        if (level.hasNeighborSignal(blockPos)) {
            return;
        }
        if (++blockEntity.tick % 32 == 0) {
            blockEntity.tick = 0;
            BlockState block = level.getBlockState(blockPos.above());
            if (block.is(Blocks.SNOW) || block.is(Blocks.SNOW_BLOCK)) {
                LevelUtil.setAir(level, blockPos.above());
            }
        }
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, ChimneyBlockEntity blockEntity) {
        if (level.hasNeighborSignal(blockPos)) {
            return;
        }
        if (!level.getBlockState(blockPos.above()).isAir()) {
            return;
        }
        RandomSource random = level.getRandom();
        double px = (float)blockPos.getX() + random.nextFloat();
        double py = (float)blockPos.getY() + random.nextFloat() * 0.5f + 1.0f;
        double pz = (float)blockPos.getZ() + random.nextFloat();
        level.addParticle((ParticleOptions)new ChimneyParticleOptions(blockEntity.color), px, py, pz, 0.0, 0.0, 0.0);
    }

    public void changeColor(ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            this.color = dye.getDyeColor().getFireworkColor();
            this.setChanged();
        }
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.color = input.getInt("color").orElse(DyeColor.BLACK.getFireworkColor());
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putInt("color", this.color);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf out) {
        super.writeToBuf(out);
        out.writeVarInt(this.color);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf in) {
        super.readFromBuf(in);
        this.color = in.readVarInt();
    }
}

