/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import mods.railcraft.api.charge.Charge;
import mods.railcraft.particle.ForceSpawnParticleOptions;
import mods.railcraft.util.FunctionalUtil;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.world.item.Magnifiable;
import mods.railcraft.world.level.block.ForceTrackEmitterBlock;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.entity.ForceTrackEmitterState;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.track.ForceTrackBlockEntity;
import mods.railcraft.world.level.block.track.ForceTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ForceTrackEmitterBlockEntity
extends RailcraftBlockEntity
implements Magnifiable {
    private static final int BASE_DRAW = 22;
    private static final int CHARGE_PER_TRACK = 2;
    private int trackCount;
    private ForceTrackEmitterState.Instance stateInstance;
    private boolean removingTrack;

    public ForceTrackEmitterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK_EMITTER.get(), blockPos, blockState);
        this.loadState(ForceTrackEmitterState.RETRACTED);
    }

    public ForceTrackEmitterState.Instance getStateInstance() {
        return this.stateInstance;
    }

    public int getTrackCount() {
        return this.trackCount;
    }

    public void checkSignal() {
        if (this.level.isClientSide()) {
            return;
        }
        boolean powered = this.level.hasNeighborSignal(this.getBlockPos());
        if (this.isPowered() != powered) {
            this.setPowered(powered);
        }
    }

    private void loadState(ForceTrackEmitterState state) {
        this.stateInstance = state.load(this);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, ForceTrackEmitterBlockEntity blockEntity) {
        if (!blockEntity.isPowered()) {
            blockEntity.stateInstance.uncharged().ifPresent(blockEntity::loadState);
            return;
        }
        int draw = ForceTrackEmitterBlockEntity.getRequiredEnergy(blockEntity.getTrackCount());
        Charge.Access access = Charge.distribution.network((ServerLevel)level).access(blockPos);
        if (access.useCharge(draw, false)) {
            blockEntity.stateInstance.charged(access).ifPresent(blockEntity::loadState);
        } else {
            blockEntity.stateInstance.uncharged().ifPresent(blockEntity::loadState);
        }
    }

    private void spawnParticles(BlockPos pos) {
        if (this.level.isClientSide()) {
            return;
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int color = ((DyeColor)this.getBlockState().getValue(ForceTrackEmitterBlock.COLOR)).getFireworkColor();
        ServerLevel serverLevel = (ServerLevel)this.level;
        serverLevel.sendParticles((ParticleOptions)new ForceSpawnParticleOptions(color), (double)x + 0.1, (double)y, (double)z + 0.1, 1, 0.0, 0.0, 0.0, 0.0);
        serverLevel.sendParticles((ParticleOptions)new ForceSpawnParticleOptions(color), (double)x + 0.9, (double)y, (double)z + 0.1, 1, 0.0, 0.0, 0.0, 0.0);
        serverLevel.sendParticles((ParticleOptions)new ForceSpawnParticleOptions(color), (double)x + 0.1, (double)y, (double)z + 0.9, 1, 0.0, 0.0, 0.0, 0.0);
        serverLevel.sendParticles((ParticleOptions)new ForceSpawnParticleOptions(color), (double)x + 0.9, (double)y, (double)z + 0.9, 1, 0.0, 0.0, 0.0, 0.0);
        serverLevel.playSound(null, pos, SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 0.25f, 1.0f);
    }

    boolean placeTrack(BlockPos blockPos, BlockState existingBlockState, RailShape railShape) {
        BlockEntity blockEntity;
        if (!existingBlockState.isAir()) {
            return false;
        }
        this.spawnParticles(blockPos);
        BlockState trackBlockState = (BlockState)((ForceTrackBlock)RailcraftBlocks.FORCE_TRACK.get()).defaultBlockState().setValue(ForceTrackBlock.SHAPE, (Comparable)railShape);
        if (this.level.setBlockAndUpdate(blockPos, trackBlockState) && (blockEntity = this.level.getBlockEntity(blockPos)) instanceof ForceTrackBlockEntity) {
            ForceTrackBlockEntity track = (ForceTrackBlockEntity)blockEntity;
            track.setEmitter(this);
            ++this.trackCount;
            return true;
        }
        return false;
    }

    public static int getRequiredEnergy(int tracks) {
        return 22 + 2 * tracks;
    }

    void removeFirstTrack() {
        BlockPos toRemove = this.worldPosition.above().relative(ForceTrackEmitterBlock.getFacing(this.getBlockState()), this.trackCount);
        this.removeTrack(toRemove);
    }

    private void clearTracks() {
        this.clearTracks(this.getBlockPos().above().relative(ForceTrackEmitterBlock.getFacing(this.getBlockState())));
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        this.clearTracks();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ((ForceTrackEmitterBlock)state.getBlock()).deregisterNode(serverLevel, pos);
        }
    }

    public void clearTracks(BlockPos startPos) {
        if (this.removingTrack || this.trackCount <= 0) {
            return;
        }
        BlockPos endPos = this.getBlockPos().above().relative(ForceTrackEmitterBlock.getFacing(this.getBlockState()), this.trackCount);
        if (startPos.getX() == endPos.getX()) {
            FunctionalUtil.rangeClosed(startPos.getZ(), endPos.getZ()).mapToObj(z -> new BlockPos(endPos.getX(), endPos.getY(), z)).forEach(this::removeTrack);
        } else if (startPos.getZ() == endPos.getZ()) {
            FunctionalUtil.rangeClosed(startPos.getX(), endPos.getX()).mapToObj(x -> new BlockPos(x, endPos.getY(), endPos.getZ())).forEach(this::removeTrack);
        } else {
            throw new IllegalStateException("Block not aligned.");
        }
        this.notifyTrackChange();
    }

    private void removeTrack(BlockPos blockPos) {
        if (this.trackCount <= 0) {
            throw new IllegalStateException("trackCount must be greater than 0");
        }
        this.removingTrack = true;
        if (this.level.isLoaded(blockPos) && this.level.getBlockState(blockPos).is((Block)RailcraftBlocks.FORCE_TRACK.get())) {
            LevelUtil.setAir(this.level, blockPos);
            this.spawnParticles(blockPos);
        }
        --this.trackCount;
        this.removingTrack = false;
    }

    public void notifyTrackChange() {
        this.loadState(ForceTrackEmitterState.HALTED);
    }

    private boolean isPowered() {
        return (Boolean)this.getBlockState().getValue((Property)ForceTrackEmitterBlock.POWERED);
    }

    private void setPowered(boolean powered) {
        BlockState state = this.getBlockState();
        if (state.is((Block)RailcraftBlocks.FORCE_TRACK_EMITTER.get())) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)ForceTrackEmitterBlock.POWERED, (Comparable)Boolean.valueOf(powered)));
        }
    }

    public boolean setColor(DyeColor color) {
        if (this.getBlockState().getValue(ForceTrackEmitterBlock.COLOR) != color) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(ForceTrackEmitterBlock.COLOR, (Comparable)color));
            if (!this.level.isClientSide()) {
                this.clearTracks();
            }
            return true;
        }
        return false;
    }

    @Override
    public void onMagnify(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)"gui.railcraft.force.track.emitter.info", (Object[])new Object[]{this.getTrackCount()}), true);
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putInt("trackCount", this.getTrackCount());
        output.store("state", ForceTrackEmitterState.CODEC, (Object)this.stateInstance.state());
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.trackCount = input.getIntOr("trackCount", 0);
        input.read("state", ForceTrackEmitterState.CODEC).ifPresent(this::loadState);
    }
}

