/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import mods.railcraft.network.to_client.OpenLogBookScreen;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;

public class LogBookBlockEntity
extends RailcraftBlockEntity {
    private static final float SEARCH_RADIUS = 16.0f;
    private static final int BOOK_LINES_PER_PAGE = 13;
    private final Multimap<LocalDate, String> log = HashMultimap.create();
    private int clock = 0;

    public LogBookBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.LOGBOOK.get(), blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, LogBookBlockEntity blockEntity) {
        LocalDate date;
        boolean isChanged;
        List<Player> players;
        if (++blockEntity.clock % 32 == 0 && !(players = EntitySearcher.find(Player.class).at(blockPos).inflateHorizontally(16.0).list(level)).isEmpty() && (isChanged = blockEntity.log.putAll((Object)(date = LocalDate.now()), players.stream().map(Player::nameAndId).map(NameAndId::name).toList()))) {
            blockEntity.setChanged();
        }
    }

    public void use(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new OpenLogBookScreen(LogBookBlockEntity.getPages(this.log)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static List<List<String>> getPages(Multimap<LocalDate, String> log) {
        ArrayList<List<String>> pages = new ArrayList<List<String>>();
        ArrayList days = new ArrayList(log.keySet());
        days.sort(Comparator.reverseOrder());
        for (LocalDate day : days) {
            List<String> page = LogBookBlockEntity.makePage(pages, day);
            for (String profile : log.get((Object)day)) {
                if (page.size() > 13) {
                    page = LogBookBlockEntity.makePage(pages, day);
                }
                page.add(profile);
            }
        }
        return pages;
    }

    private static List<String> makePage(List<List<String>> pages, LocalDate date) {
        LinkedList<String> page = new LinkedList<String>();
        page.add(date.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT)));
        page.add(StringUtils.repeat((char)'-', (int)34));
        pages.add(page);
        return page;
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.store("log", DateEntry.CODEC.listOf(), LogBookBlockEntity.convertMapToLog(this.log));
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.log.clear();
        input.read("log", DateEntry.CODEC.listOf()).ifPresent(dateEntries -> this.log.putAll(LogBookBlockEntity.convertLogToMap(dateEntries)));
    }

    private static List<DateEntry> convertMapToLog(Multimap<LocalDate, String> log) {
        LocalDate monthAgo = LocalDate.now().minusMonths(1L);
        return log.asMap().entrySet().stream().filter(entry -> !((LocalDate)entry.getKey()).isBefore(monthAgo)).map(entry -> {
            String date = ((LocalDate)entry.getKey()).toString();
            ArrayList<String> players = new ArrayList<String>((Collection)entry.getValue());
            return new DateEntry(date, players);
        }).toList();
    }

    private static Multimap<LocalDate, String> convertLogToMap(List<DateEntry> dateEntries) {
        HashMultimap log = HashMultimap.create();
        LocalDate monthAgo = LocalDate.now().minusMonths(1L);
        for (DateEntry dateEntry : dateEntries) {
            LocalDate date = LocalDate.parse(dateEntry.date);
            if (date.isBefore(monthAgo)) continue;
            HashSet<String> players = new HashSet<String>(dateEntry.players);
            log.putAll((Object)date, players);
        }
        return log;
    }

    private record DateEntry(String date, List<String> players) {
        public static final Codec<DateEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("date").forGetter(DateEntry::date), (App)Codec.STRING.listOf().fieldOf("players").forGetter(DateEntry::players)).apply((Applicative)instance, DateEntry::new));
    }
}

