/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import java.util.Collection;
import java.util.Optional;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.world.inventory.ManualRollingMachineMenu;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.item.crafting.RollingRecipe;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import org.jetbrains.annotations.Nullable;

public class ManualRollingMachineBlockEntity
extends RailcraftBlockEntity
implements MenuProvider {
    private final AdvancedContainer invResult;
    private final FakeRollingContainer matrixListener = new FakeRollingContainer();
    protected final RollingCraftingContainer craftMatrix = new RollingCraftingContainer(this.matrixListener, 3, 3);
    protected boolean isWorking;
    protected boolean useLast;
    private Optional<RecipeHolder<RollingRecipe>> currentRecipe = Optional.empty();
    private int progress;
    private int clock = 0;
    private int processTime = 100;

    public ManualRollingMachineBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.invResult = new AdvancedContainer(1);
    }

    public ManualRollingMachineBlockEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)RailcraftBlockEntityTypes.MANUAL_ROLLING_MACHINE.get(), blockPos, blockState);
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putChild("container", (ValueIOSerializable)this.invResult);
        ContainerHelper.saveAllItems((ValueOutput)output.child("craftMatrix"), (NonNullList)NonNullList.copyOf((Collection)this.craftMatrix.getItems()), (boolean)false);
        output.putInt("progress", this.progress);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.readChild("container", (ValueIOSerializable)this.invResult);
        input.child("craftMatrix").ifPresent(input1 -> {
            NonNullList tempItems = NonNullList.withSize((int)this.craftMatrix.getContainerSize(), (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((ValueInput)input1, (NonNullList)tempItems);
            for (int i = 0; i < tempItems.size(); ++i) {
                this.craftMatrix.setItem(i, (ItemStack)tempItems.get(i));
            }
        });
        this.progress = input.getIntOr("progress", 0);
    }

    public void setChanged() {
        super.setChanged();
        this.craftMatrix.setChanged();
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setProcessTime(int processTime) {
        this.processTime = Math.max(processTime, 1);
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public RollingCraftingContainer getCraftMatrix(AbstractContainerMenu listener) {
        this.matrixListener.listener = listener;
        return this.craftMatrix;
    }

    public AdvancedContainer getInvResult() {
        return this.invResult;
    }

    public Optional<RecipeHolder<RollingRecipe>> getRecipe(ServerLevel level) {
        return level.recipeAccess().getRecipeFor((RecipeType)RailcraftRecipeTypes.ROLLING.get(), (RecipeInput)this.craftMatrix.asCraftInput(), this.level);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, ManualRollingMachineBlockEntity blockEntity) {
        blockEntity.balanceSlots();
        if (++blockEntity.clock % 8 == 0) {
            blockEntity.currentRecipe = blockEntity.getRecipe((ServerLevel)level);
            blockEntity.processTime = blockEntity.currentRecipe.map(RecipeHolder::value).map(RollingRecipe::getProcessTime).orElse(100);
            blockEntity.clock = 0;
        }
        if (blockEntity.currentRecipe.isPresent() && blockEntity.canMakeMore((ServerLevel)level)) {
            RecipeHolder<RollingRecipe> recipe = blockEntity.currentRecipe.get();
            if (blockEntity.progress >= ((RollingRecipe)recipe.value()).getProcessTime()) {
                blockEntity.isWorking = false;
                ItemStack result = ((RollingRecipe)recipe.value()).assemble(blockEntity.craftMatrix.asCraftInput(), (HolderLookup.Provider)level.registryAccess());
                if (blockEntity.invResult.canFit(result)) {
                    blockEntity.craftMatrix.getItems().forEach(x -> x.shrink(1));
                    blockEntity.invResult.insert(result);
                    blockEntity.useLast = false;
                    blockEntity.progress = 0;
                    blockEntity.currentRecipe = Optional.empty();
                }
            } else {
                blockEntity.isWorking = true;
                blockEntity.progress();
            }
        } else {
            blockEntity.progress = 0;
            blockEntity.isWorking = false;
        }
    }

    protected void progress() {
        ++this.progress;
    }

    private void balanceSlots() {
        int size = this.craftMatrix.getContainerSize();
        for (int i = 0; i < size; ++i) {
            ItemStack stackA = this.craftMatrix.getItem(i);
            if (stackA.isEmpty()) continue;
            for (int j = 0; j < size; ++j) {
                ItemStack stackB;
                if (i == j || (stackB = this.craftMatrix.getItem(j)).isEmpty() || !ItemStack.isSameItem((ItemStack)stackA, (ItemStack)stackB) || stackA.getCount() <= stackB.getCount() + 1) continue;
                stackA.shrink(1);
                stackB.grow(1);
                this.craftMatrix.setItem(i, stackA);
                this.craftMatrix.setItem(j, stackB);
                return;
            }
        }
    }

    public void setUseLast() {
        this.useLast = true;
    }

    public boolean canMakeMore(ServerLevel level) {
        if (this.getRecipe(level).isEmpty()) {
            return false;
        }
        if (this.useLast) {
            return true;
        }
        return this.craftMatrix.getItems().stream().filter(x -> !x.isEmpty()).allMatch(x -> x.getCount() > 1);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new ManualRollingMachineMenu(containerId, inventory, this);
    }

    private static class FakeRollingContainer
    extends AbstractContainerMenu {
        @Nullable
        AbstractContainerMenu listener = null;

        public FakeRollingContainer() {
            super(null, 0);
        }

        public ItemStack quickMoveStack(Player player, int index) {
            return ItemStack.EMPTY;
        }

        public boolean stillValid(Player player) {
            return true;
        }

        public void slotsChanged(Container container) {
            if (this.listener != null) {
                this.listener.slotsChanged(container);
            }
        }
    }

    public static class RollingCraftingContainer
    extends TransientCraftingContainer {
        private RollingCraftingContainer(FakeRollingContainer menu, int width, int height) {
            super((AbstractContainerMenu)menu, width, height);
        }

        public boolean canPlaceItem(int index, ItemStack stack) {
            if (stack.isEmpty()) {
                return false;
            }
            if (!stack.isStackable()) {
                return false;
            }
            return !this.getItem(index).isEmpty();
        }
    }
}

