/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import com.mojang.datafixers.util.Either;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.ModifiableSlotAccessor;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.routing.RouterBlockEntity;
import mods.railcraft.util.routing.RoutingLogic;
import mods.railcraft.util.routing.RoutingLogicException;
import mods.railcraft.world.inventory.detector.RoutingDetectorMenu;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.detector.SecureDetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.players.NameAndId;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import org.jetbrains.annotations.Nullable;

public class RoutingDetectorBlockEntity
extends SecureDetectorBlockEntity
implements ContainerManipulator<ModifiableSlotAccessor>,
RouterBlockEntity {
    private final AdvancedContainer container;
    @Nullable
    private Either<RoutingLogic, RoutingLogicException> logic;
    private RouterBlockEntity.Railway railway = RouterBlockEntity.Railway.PUBLIC;
    private boolean powered;

    public RoutingDetectorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.ROUTING_DETECTOR.get(), blockPos, blockState);
        this.container = new AdvancedContainer(1).listener(this);
    }

    @Override
    protected int testCarts(List<AbstractMinecart> minecarts) {
        if (this.logic().isEmpty()) {
            return 0;
        }
        for (AbstractMinecart cart : minecarts) {
            RollingStock rollingStock = RollingStock.getOrThrow(cart);
            if (this.railway == RouterBlockEntity.Railway.PRIVATE && rollingStock.owner().filter(owner -> owner.equals((Object)this.getOwnerOrThrow())).isEmpty() || !this.logic().map(logic -> logic.matches(this, rollingStock)).orElse(false).booleanValue()) continue;
            return 15;
        }
        return 0;
    }

    @Override
    public void neighborChanged() {
        this.powered = this.level.hasNeighborSignal(this.getBlockPos());
        this.setChanged();
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        Containers.updateNeighboursAfterDestroy((BlockState)state, (Level)this.level, (BlockPos)pos);
    }

    @Override
    public RouterBlockEntity.Railway getRailway() {
        return this.railway;
    }

    @Override
    public void setRailway(@Nullable NameAndId gameProfile) {
        RouterBlockEntity.Railway railway = this.railway = gameProfile == null ? RouterBlockEntity.Railway.PUBLIC : RouterBlockEntity.Railway.PRIVATE;
        if (!this.isLocked()) {
            this.setOwner(gameProfile);
        }
    }

    @Override
    public Stream<ModifiableSlotAccessor> stream() {
        return this.container.stream();
    }

    @Override
    public Container container() {
        return this.container;
    }

    @Override
    public boolean stillValid(Player player) {
        return this.isStillValid(player);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.readChild("container", (ValueIOSerializable)this.container);
        this.railway = input.read("railway", RouterBlockEntity.Railway.CODEC).orElse(RouterBlockEntity.Railway.PUBLIC);
        this.powered = input.getBooleanOr("powered", false);
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putChild("container", (ValueIOSerializable)this.container);
        output.store("railway", RouterBlockEntity.Railway.CODEC, (Object)this.railway);
        output.putBoolean("powered", this.powered);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeEnum((Enum)this.railway);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.railway = (RouterBlockEntity.Railway)data.readEnum(RouterBlockEntity.Railway.class);
        this.powered = data.readBoolean();
    }

    @Override
    public Optional<Either<RoutingLogic, RoutingLogicException>> logicResult() {
        this.refreshLogic();
        return Optional.ofNullable(this.logic);
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void resetLogic() {
        this.logic = null;
    }

    private void refreshLogic() {
        ItemStack item;
        if (this.logic == null && !this.container.getItem(0).isEmpty() && (item = this.container.getItem(0)).has(RailcraftDataComponents.ROUTING_TABLE_BOOK)) {
            Deque content = this.loadPages(item);
            try {
                this.logic = Either.left((Object)RoutingLogic.parseTable(content));
            }
            catch (RoutingLogicException e) {
                this.logic = Either.right((Object)e);
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new RoutingDetectorMenu(id, inventory, this);
    }
}

