/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.manipulator;

import mods.railcraft.RailcraftConfig;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.inventory.CartDispenserMenu;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class CartDispenserBlockEntity
extends ManipulatorBlockEntity
implements MenuProvider {
    protected boolean powered;
    protected int timeSinceLastSpawn;

    public CartDispenserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RailcraftBlockEntityTypes.CART_DISPENSER.get(), pos, state);
        this.setContainerSize(3);
    }

    protected CartDispenserBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, CartDispenserBlockEntity blockEntity) {
        if (blockEntity.timeSinceLastSpawn < Integer.MAX_VALUE) {
            ++blockEntity.timeSinceLastSpawn;
        }
    }

    @Override
    protected boolean hasWorkForCart(AbstractMinecart cart) {
        return false;
    }

    @Override
    protected void processCart(AbstractMinecart cart) {
    }

    public void onNeighborChange() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean newPowered = this.isPowered();
        if (!this.powered && newPowered) {
            this.powered = true;
            this.setPowered(true);
            this.onPulse(serverLevel);
        } else {
            this.powered = newPowered;
            this.setPowered(this.powered);
        }
    }

    protected void onPulse(ServerLevel serverLevel) {
        EntitySearcher.findMinecarts().at(this.getBlockPos().offset(this.getFacing().getUnitVec3i())).stream((Level)serverLevel).findAny().ifPresentOrElse(cart -> {
            ItemStack remainder;
            if (!cart.isAlive()) {
                return;
            }
            AdvancedContainer coppiedContainer = AdvancedContainer.copyOf(this);
            ItemStack cartStack = cart.getPickResult();
            if (cart.hasCustomName()) {
                cartStack.set(DataComponents.CUSTOM_NAME, (Object)cart.getName());
            }
            if ((remainder = coppiedContainer.insert(cartStack.copy())).isEmpty()) {
                this.insert(cartStack);
                if (!cart.getPassengers().isEmpty()) {
                    MinecartUtil.removePassengers(cart);
                }
                cart.kill(serverLevel);
            }
        }, () -> {
            if (this.timeSinceLastSpawn > (Integer)RailcraftConfig.SERVER.cartDispenserDelay.get() * 20) {
                for (int i = 0; i < this.getContainerSize(); ++i) {
                    ItemStack cartStack = this.getItem(i);
                    if (cartStack.isEmpty()) continue;
                    BlockPos pos = this.getBlockPos().offset(this.getFacing().getUnitVec3i());
                    AbstractMinecart placedCart = MinecartUtil.placeCart(cartStack, serverLevel, pos);
                    if (placedCart != null) {
                        this.removeItem(i, 1);
                        this.timeSinceLastSpawn = 0;
                        break;
                    }
                    LevelUtil.spewItem(cartStack, this.level, pos.getX(), pos.getY(), pos.getZ());
                    this.setItem(i, ItemStack.EMPTY);
                }
            }
        });
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new CartDispenserMenu(id, inventory, this);
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putBoolean("powered", this.powered);
        output.putInt("timeSinceLastSpawn", this.timeSinceLastSpawn);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.powered = input.getBooleanOr("powered", false);
        this.timeSinceLastSpawn = input.getIntOr("timeSinceLastSpawn", 0);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeBoolean(this.powered);
        data.writeInt(this.timeSinceLastSpawn);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.powered = data.readBoolean();
        this.timeSinceLastSpawn = data.readInt();
    }
}

