/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.multiblock;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockPattern;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class MultiblockBlockEntity<T extends MultiblockBlockEntity<T, M>, M>
extends RailcraftBlockEntity
implements MenuProvider {
    private static final Logger logger = LogUtils.getLogger();
    private final Class<T> clazz;
    private final Collection<MultiblockPattern<M>> patterns;
    @Nullable
    private Membership<T> membership;
    @Nullable
    private Map<BlockPos, T> members;
    @Nullable
    private MultiblockPattern<M> currentPattern;
    private boolean evaluationPending;
    @Nullable
    private UnresolvedMembership unresolvedMembership;

    public MultiblockBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, Class<T> clazz, MultiblockPattern<M> pattern) {
        this(type, blockPos, blockState, clazz, Collections.singleton(pattern));
    }

    public MultiblockBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, Class<T> clazz, Collection<MultiblockPattern<M>> patterns) {
        super(type, blockPos, blockState);
        this.clazz = clazz;
        this.patterns = Collections.unmodifiableCollection(patterns);
    }

    public Collection<MultiblockPattern<M>> getPatterns() {
        return this.patterns;
    }

    public void enqueueEvaluation() {
        this.evaluationPending = true;
    }

    protected void serverTick() {
        if (this.evaluationPending) {
            this.evaluate();
        }
    }

    public InteractionResult use(ServerPlayer player, InteractionHand hand) {
        player.openMenu((MenuProvider)this, this.getBlockPos());
        return InteractionResult.CONSUME;
    }

    public void evaluate() {
        if (this.level.isClientSide()) {
            return;
        }
        this.evaluationPending = false;
        if (this.isFormed() && !this.isMaster()) {
            ((MultiblockBlockEntity)this.membership.master).evaluate();
            return;
        }
        Optional<Pair<MultiblockPattern<M>, Map<BlockPos, MultiblockPattern.Element>>> pattern = this.resolvePattern();
        if (this.isFormed() && (!this.isMaster() || pattern.isPresent()) || !this.isFormed() && pattern.isEmpty()) {
            return;
        }
        pattern.ifPresentOrElse(pair -> {
            this.currentPattern = (MultiblockPattern)pair.getLeft();
            this.members = new HashMap<BlockPos, T>();
            Map resolvedPattern = (Map)pair.getRight();
            for (Map.Entry entry : resolvedPattern.entrySet()) {
                if (!this.isBlockEntity((MultiblockPattern.Element)entry.getValue())) continue;
                MultiblockBlockEntity blockEntity = LevelUtil.getBlockEntity((BlockGetter)this.level, (BlockPos)entry.getKey(), this.clazz).orElse(null);
                if (blockEntity == null) {
                    logger.warn("Invalid block @ [{}]", entry.getKey());
                    this.disband();
                    return;
                }
                if (blockEntity.getMembership().isPresent()) {
                    this.disband();
                    return;
                }
                blockEntity.setMembership(new Membership<MultiblockBlockEntity>((MultiblockPattern.Element)entry.getValue(), (MultiblockBlockEntity)this.clazz.cast(this)));
                this.members.put((BlockPos)entry.getKey(), blockEntity);
            }
        }, this::disband);
    }

    private void disband() {
        this.currentPattern = null;
        if (this.members == null) {
            return;
        }
        for (Map.Entry<BlockPos, T> entry : this.members.entrySet()) {
            if (((MultiblockBlockEntity)entry.getValue()).isRemoved()) continue;
            ((MultiblockBlockEntity)entry.getValue()).setMembership(null);
        }
        this.members = null;
    }

    protected abstract boolean isBlockEntity(MultiblockPattern.Element var1);

    public Optional<Pair<MultiblockPattern<M>, Map<BlockPos, MultiblockPattern.Element>>> resolvePattern() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return this.patterns.stream().flatMap(pattern -> pattern.resolve(this.getBlockPos(), serverLevel).map(map -> Pair.of((Object)pattern, (Object)map)).stream()).findAny();
        }
        throw new IllegalStateException("Resolving multiblock pattern on invalid side.");
    }

    protected void setMembership(@Nullable Membership<T> membership) {
        this.membership = membership;
        this.membershipChanged(membership);
        this.setChanged();
        this.syncToClient();
    }

    protected abstract void membershipChanged(@Nullable Membership<T> var1);

    public boolean isFormed() {
        return this.membership != null;
    }

    public boolean isMaster() {
        return this.level.isClientSide() ? this.unresolvedMembership != null && this.unresolvedMembership.masterPos().equals((Object)this.worldPosition) : this.membership != null && this.membership.master() == this;
    }

    public Optional<Membership<T>> getMembership() {
        return this.level.isClientSide() ? Optional.empty() : Optional.ofNullable(this.membership);
    }

    public Optional<T> getMasterBlockEntity() {
        return this.getMembership().map(Membership::master);
    }

    public Optional<MultiblockPattern<M>> getCurrentPattern() {
        return Optional.ofNullable(this.currentPattern);
    }

    public Optional<UnresolvedMembership> getUnresolvedMembership() {
        if (!this.level.isClientSide()) {
            throw new IllegalStateException("getUnresolvedMembership is client-side only.");
        }
        return Optional.ofNullable(this.unresolvedMembership);
    }

    public Optional<Collection<T>> getMembers() {
        return Optional.ofNullable(this.members).map(Map::values);
    }

    public Stream<T> streamMembers() {
        return Stream.ofNullable(this.members).map(Map::values).flatMap(Collection::stream);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        if (input.getBooleanOr("master", false)) {
            this.enqueueEvaluation();
        }
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putBoolean("master", this.membership != null && this.membership.master() == this);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf out) {
        super.writeToBuf(out);
        out.writeNullable(this.membership, (buf, membership) -> {
            MultiblockPattern.Element patternElement = membership.patternElement();
            buf.writeBlockPos(patternElement.relativePos());
            buf.writeChar((int)patternElement.marker());
            buf.writeBlockPos(membership.master().getBlockPos());
        });
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf in) {
        super.readFromBuf(in);
        this.unresolvedMembership = (UnresolvedMembership)in.readNullable(buf -> new UnresolvedMembership(new MultiblockPattern.Element(buf.readBlockPos(), buf.readChar()), buf.readBlockPos()));
    }

    public record Membership<T extends MultiblockBlockEntity<T, ?>>(MultiblockPattern.Element patternElement, T master) {
    }

    public record UnresolvedMembership(MultiblockPattern.Element patternElement, BlockPos masterPos) {
    }
}

