/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import mods.railcraft.api.signal.BlockSignalEntity;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.SimpleBlockSignalNetwork;
import mods.railcraft.api.signal.SimpleSignalController;
import mods.railcraft.api.signal.entity.SignalControllerEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;

public class BlockSignalBlockEntity
extends AbstractSignalBlockEntity
implements SignalControllerEntity,
BlockSignalEntity {
    private final SimpleSignalController signalController = new SimpleSignalController(1, this::syncToClient, this, false, __ -> this.level.getLightEngine().checkBlock(this.getBlockPos()));
    private final SimpleBlockSignalNetwork blockSignal = new SimpleBlockSignalNetwork(1, this::syncToClient, this.signalController::setSignalAspect, (BlockEntity)this);

    public BlockSignalBlockEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)RailcraftBlockEntityTypes.BLOCK_SIGNAL.get(), blockPos, blockState);
    }

    public BlockSignalBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        this.blockRemoved();
    }

    protected void blockRemoved() {
        this.signalController.destroy();
        this.blockSignal.destroy();
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide()) {
            this.signalController.refresh();
            this.blockSignal.refresh();
        }
    }

    @Override
    public SignalAspect getPrimarySignalAspect() {
        return this.blockSignal.aspect();
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putChild("blockSignal", (ValueIOSerializable)this.blockSignal);
        output.putChild("signalController", (ValueIOSerializable)this.signalController);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.readChild("blockSignal", (ValueIOSerializable)this.blockSignal);
        input.readChild("signalController", (ValueIOSerializable)this.signalController);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        this.blockSignal.writeToBuf(data);
        this.signalController.writeToBuf(data);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.blockSignal.readFromBuf(data);
        this.signalController.readFromBuf(data);
    }

    @Override
    public SimpleSignalController getSignalController() {
        return this.signalController;
    }

    @Override
    public SimpleBlockSignalNetwork signalNetwork() {
        return this.blockSignal;
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, BlockSignalBlockEntity blockEntity) {
        blockEntity.signalController.spawnTuningAuraParticles();
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, BlockSignalBlockEntity blockEntity) {
        blockEntity.blockSignal.serverTick();
    }
}

