/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.SignalReceiver;
import mods.railcraft.api.signal.SingleSignalReceiver;
import mods.railcraft.api.signal.entity.SignalReceiverEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.signal.ActionSignalBoxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;

public class SignalReceiverBoxBlockEntity
extends ActionSignalBoxBlockEntity
implements SignalReceiverEntity {
    private final SingleSignalReceiver signalReceiver = new SingleSignalReceiver(this, this::syncToClient, __ -> this.setChanged());

    public SignalReceiverBoxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.SIGNAL_RECEIVER_BOX.get(), blockPos, blockState);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide()) {
            this.signalReceiver.refresh();
        }
    }

    @Override
    protected void blockRemoved() {
        super.blockRemoved();
        this.signalReceiver.destroy();
    }

    @Override
    public int getRedstoneSignal(Direction direction) {
        return this.isActionSignalAspect(this.signalReceiver.getPrimarySignalAspect()) ? 15 : 0;
    }

    @Override
    public SignalReceiver getSignalReceiver() {
        return this.signalReceiver;
    }

    @Override
    public SignalAspect getSignalAspect(Direction direction) {
        return this.signalReceiver.getPrimarySignalAspect();
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putChild("signalReceiver", (ValueIOSerializable)this.signalReceiver);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.readChild("signalReceiver", (ValueIOSerializable)this.signalReceiver);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        this.signalReceiver.writeToBuf(data);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.signalReceiver.readFromBuf(data);
    }
}

