/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import mods.railcraft.api.carts.Routable;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.ForwardingContainer;
import mods.railcraft.world.inventory.RoutingTrackMenu;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.track.LockableTrackBlockEntity;
import mods.railcraft.world.level.block.track.outfitted.PoweredOutfittedTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.RoutingTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import org.jetbrains.annotations.Nullable;

public class RoutingTrackBlockEntity
extends LockableTrackBlockEntity
implements ForwardingContainer,
MenuProvider {
    private final AdvancedContainer container = new AdvancedContainer(1).listener(this);

    public RoutingTrackBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.ROUTING_TRACK.get(), blockPos, blockState);
    }

    public void minecartPassed(AbstractMinecart cart) {
        ItemStack stack;
        if (PoweredOutfittedTrackBlock.isPowered(this.getBlockState()) && !(stack = this.container.getItem(0)).isEmpty() && cart instanceof Routable) {
            Routable routable = (Routable)cart;
            routable.setDestination(stack);
        }
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        Containers.updateNeighboursAfterDestroy((BlockState)state, (Level)this.level, (BlockPos)pos);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RoutingTrackBlock block = (RoutingTrackBlock)state.getBlock();
            if (block.getTrackType().isElectric()) {
                block.deregisterNode(serverLevel, pos);
            }
        }
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putChild("container", (ValueIOSerializable)this.container);
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.readChild("container", (ValueIOSerializable)this.container);
    }

    @Override
    public Container container() {
        return this.container;
    }

    @Override
    public boolean stillValid(Player player) {
        return this.isStillValid(player);
    }

    @Override
    public Component getName() {
        return this.getDisplayName();
    }

    @Override
    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new RoutingTrackMenu(id, inventory, this);
    }
}

