/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.ArrowDirection;
import mods.railcraft.api.track.SwitchActuator;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.level.block.track.actuator.SwitchTrackActuatorBlock;
import mods.railcraft.world.level.block.track.outfitted.SwitchTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public abstract class SwitchTrackBlockEntity
extends BlockEntity {
    private static final int SPRING_DURATION = 30;
    protected Set<UUID> lockingCarts = new HashSet<UUID>();
    protected Set<UUID> springingCarts = new HashSet<UUID>();
    protected Set<UUID> decidingCarts = new HashSet<UUID>();
    private byte sprung;
    private byte locked;
    @Nullable
    private RollingStock currentCart;
    @Nullable
    private UUID unresolvedCurrentCart;

    public SwitchTrackBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, SwitchTrackBlockEntity blockEntity) {
        boolean switched;
        if (blockEntity.locked > 0) {
            blockEntity.locked = (byte)(blockEntity.locked - 1);
        }
        if (blockEntity.sprung > 0) {
            blockEntity.sprung = (byte)(blockEntity.sprung - 1);
        }
        if (blockEntity.locked == 0 && blockEntity.sprung == 0) {
            blockEntity.lockingCarts.clear();
            blockEntity.springingCarts.clear();
            blockEntity.decidingCarts.clear();
            blockEntity.currentCart = null;
        }
        blockEntity.updateSet(blockEntity.lockingCarts, blockEntity.getCartsAtLockEntrance(), blockEntity.springingCarts, blockEntity.decidingCarts);
        blockEntity.updateSet(blockEntity.springingCarts, blockEntity.getCartsAtSpringEntrance(), blockEntity.lockingCarts, blockEntity.decidingCarts);
        blockEntity.updateSet(blockEntity.decidingCarts, blockEntity.getCartsAtDecisionEntrance(), blockEntity.lockingCarts, blockEntity.springingCarts);
        List<AbstractMinecart> cartsOnTrack = EntitySearcher.findMinecarts().at(blockPos).inflate(-0.3f).list(level);
        Set uuidOnTrack = cartsOnTrack.stream().map(Entity::getUUID).collect(Collectors.toSet());
        AbstractMinecart bestCart = blockEntity.getBestCartForVisualState(cartsOnTrack);
        boolean wasSwitched = SwitchTrackBlock.isSwitched(blockState);
        BlockPos actuatorBlockPos = blockEntity.getActuatorBlockPos();
        BlockState actuatorBlockState = level.getBlockState(actuatorBlockPos);
        boolean actuatorPresent = actuatorBlockState.is(RailcraftTags.Blocks.SWITCH_TRACK_ACTUATOR);
        boolean actuatorSwitched = actuatorPresent && SwitchTrackActuatorBlock.isSwitched(actuatorBlockState);
        boolean bl = switched = !blockEntity.isLocked() && (actuatorSwitched || blockEntity.isSprung());
        if (bestCart != null && uuidOnTrack.contains(bestCart.getUUID())) {
            RollingStock rollingStock = RollingStock.getOrThrow(bestCart);
            if (blockEntity.shouldSwitchForCart(rollingStock)) {
                blockEntity.springTrack(rollingStock);
            } else {
                blockEntity.lockTrack(rollingStock);
            }
        }
        if (switched != wasSwitched) {
            level.setBlockAndUpdate(blockEntity.getBlockPos(), (BlockState)blockState.setValue((Property)SwitchTrackBlock.SWITCHED, (Comparable)Boolean.valueOf(switched)));
            if (actuatorPresent) {
                if (actuatorSwitched != switched) {
                    SwitchTrackActuatorBlock.setSwitched(actuatorBlockState, blockEntity.level, actuatorBlockPos, switched);
                }
                SwitchTrackActuatorBlock.updateArrowDirections(actuatorBlockState, blockEntity.level, actuatorBlockPos, blockEntity.getRedArrowDirection(), blockEntity.getWhiteArrowDirection());
            }
        }
    }

    protected abstract ArrowDirection getRedArrowDirection();

    protected abstract ArrowDirection getWhiteArrowDirection();

    @Nullable
    private AbstractMinecart getBestCartForVisualState(List<AbstractMinecart> cartsOnTrack) {
        if (!cartsOnTrack.isEmpty()) {
            return cartsOnTrack.getFirst();
        }
        AbstractMinecart closestCart = null;
        ArrayList<UUID> allCarts = new ArrayList<UUID>();
        allCarts.addAll(this.lockingCarts);
        allCarts.addAll(this.springingCarts);
        allCarts.addAll(this.decidingCarts);
        for (UUID testCartUUID : allCarts) {
            double testDist;
            if (closestCart == null) {
                closestCart = MinecartUtil.getCartFromUUID(this.level, testCartUUID);
                continue;
            }
            double closestDist = SwitchTrackBlockEntity.crudeDistance(this.getBlockPos(), closestCart);
            AbstractMinecart testCart = MinecartUtil.getCartFromUUID(this.level, testCartUUID);
            if (testCart == null || !((testDist = SwitchTrackBlockEntity.crudeDistance(this.getBlockPos(), testCart)) < closestDist)) continue;
            closestCart = testCart;
        }
        return closestCart;
    }

    protected abstract List<UUID> getCartsAtLockEntrance();

    protected abstract List<UUID> getCartsAtSpringEntrance();

    protected abstract List<UUID> getCartsAtDecisionEntrance();

    public abstract Direction getActuatorDirection();

    public final BlockPos getActuatorBlockPos() {
        return this.getBlockPos().relative(this.getActuatorDirection());
    }

    public boolean shouldSwitchForCart(RollingStock rollingStock) {
        AbstractMinecart entity = rollingStock.entity();
        if (this.springingCarts.contains(entity.getUUID())) {
            return true;
        }
        if (this.lockingCarts.contains(entity.getUUID())) {
            return false;
        }
        boolean sameTrain = this.currentCart() != null && rollingStock.isSameTrainAs(this.currentCart());
        boolean shouldSwitch = false;
        BlockEntity actuatorBlockEntity = this.level.getBlockEntity(this.getActuatorBlockPos());
        if (actuatorBlockEntity instanceof SwitchActuator) {
            SwitchActuator switchActuator = (SwitchActuator)actuatorBlockEntity;
            shouldSwitch = switchActuator.shouldSwitch(rollingStock);
        }
        if (this.isSprung()) {
            return shouldSwitch || sameTrain;
        }
        if (this.isLocked()) {
            return shouldSwitch && !sameTrain;
        }
        return shouldSwitch;
    }

    @Nullable
    private RollingStock currentCart() {
        if (this.unresolvedCurrentCart != null) {
            Entity entity = ((ServerLevel)this.level).getEntity(this.unresolvedCurrentCart);
            if (entity instanceof AbstractMinecart) {
                AbstractMinecart minecart = (AbstractMinecart)entity;
                this.currentCart = RollingStock.getOrThrow(minecart);
            }
            this.unresolvedCurrentCart = null;
        }
        return this.currentCart;
    }

    private void springTrack(RollingStock cartOnTrack) {
        this.sprung = (byte)30;
        this.locked = 0;
        this.currentCart = cartOnTrack;
    }

    private void lockTrack(RollingStock cartOnTrack) {
        this.locked = (byte)30;
        this.sprung = 0;
        this.currentCart = cartOnTrack;
    }

    public boolean isLocked() {
        return this.locked > 0;
    }

    public boolean isSprung() {
        return this.sprung > 0;
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putByte("sprung", this.sprung);
        output.putByte("locked", this.locked);
        output.store("springingCarts", UUIDUtil.CODEC.listOf(), new ArrayList<UUID>(this.springingCarts));
        output.store("lockingCarts", UUIDUtil.CODEC.listOf(), new ArrayList<UUID>(this.lockingCarts));
        output.store("decidingCarts", UUIDUtil.CODEC.listOf(), new ArrayList<UUID>(this.decidingCarts));
        if (this.currentCart != null) {
            output.store("currentCart", UUIDUtil.CODEC, (Object)this.currentCart.entity().getUUID());
        }
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.sprung = input.getByteOr("sprung", (byte)0);
        this.locked = input.getByteOr("locked", (byte)0);
        this.springingCarts = input.read("springingCarts", UUIDUtil.CODEC.listOf()).map(HashSet::new).orElse(new HashSet());
        this.lockingCarts = input.read("lockingCarts", UUIDUtil.CODEC.listOf()).map(HashSet::new).orElse(new HashSet());
        this.decidingCarts = input.read("decidingCarts", UUIDUtil.CODEC.listOf()).map(HashSet::new).orElse(new HashSet());
        this.unresolvedCurrentCart = input.read("currentCart", UUIDUtil.CODEC).orElse(null);
    }

    private void updateSet(Set<UUID> setToUpdate, List<UUID> potentialUpdates, Set<UUID> reject1, Set<UUID> reject2) {
        for (UUID cartUUID : potentialUpdates) {
            reject1.remove(cartUUID);
            reject2.remove(cartUUID);
            setToUpdate.add(cartUUID);
        }
    }

    private static double crudeDistance(BlockPos pos, AbstractMinecart cart) {
        double cx = (double)pos.getX() + 0.5;
        double cz = (double)pos.getZ() + 0.5;
        return Math.abs(cart.getX() - cx) + Math.abs(cart.getZ() - cz);
    }
}

