/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.manipulator;

import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class ManipulatorBlock<T extends ManipulatorBlockEntity>
extends BaseEntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private final Class<T> blockEntityType;

    protected ManipulatorBlock(Class<T> blockEntityType, BlockBehaviour.Properties properties) {
        super(properties);
        this.blockEntityType = blockEntityType;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult rayTraceResult) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (!this.blockEntityType.isInstance(blockEntity)) {
                return InteractionResult.PASS;
            }
            serverPlayer.openMenu((MenuProvider)this.blockEntityType.cast(blockEntity), blockPos);
        }
        return InteractionResult.SUCCESS;
    }

    public abstract Direction getFacing(BlockState var1);

    public int getSignal(BlockState blockState, BlockGetter level, BlockPos blockPos, Direction direction) {
        boolean emit = false;
        if (ManipulatorBlock.isPowered(blockState)) {
            BlockState neighborBlockState = level.getBlockState(blockPos.relative(direction.getOpposite()));
            emit = BaseRailBlock.isRail((BlockState)neighborBlockState);
        }
        return emit ? 15 : 0;
    }

    public static boolean isPowered(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)POWERED);
    }
}

