/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.signal;

import com.mojang.serialization.MapCodec;
import mods.railcraft.Translations;
import mods.railcraft.integrations.jei.JeiSearchable;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.signal.BlockSignalBlockEntity;
import mods.railcraft.world.level.block.entity.signal.DualBlockSignalBlockEntity;
import mods.railcraft.world.level.block.signal.DualSignalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DualBlockSignalBlock
extends DualSignalBlock
implements JeiSearchable {
    private static final MapCodec<DualBlockSignalBlock> CODEC = DualBlockSignalBlock.simpleCodec(DualBlockSignalBlock::new);

    public DualBlockSignalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends DualSignalBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new DualBlockSignalBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return DualBlockSignalBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.DUAL_BLOCK_SIGNAL.get()), (BlockEntityTicker)(level.isClientSide() ? BlockSignalBlockEntity::clientTick : BlockSignalBlockEntity::serverTick));
    }

    @Override
    public Component jeiDescription() {
        return Component.translatable((String)Translations.Jei.DUAL_BLOCK_SIGNAL);
    }
}

