/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.signal;

import mods.railcraft.api.core.Lockable;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBoxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class SignalBoxBlock
extends CrossCollisionBlock {
    public static final BooleanProperty CAP = BooleanProperty.create((String)"cap");
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);

    public SignalBoxBlock(BlockBehaviour.Properties properties) {
        super(2.0f, 2.0f, 16.0f, 16.0f, 24.0f, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CAP, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean isConnected(BlockState state, Direction face) {
        BooleanProperty property = (BooleanProperty)PROPERTY_BY_DIRECTION.get(face);
        return property != null && (Boolean)state.getValue((Property)property) != false;
    }

    public static boolean isAspectEmitter(BlockState blockState) {
        return blockState.is(RailcraftTags.Blocks.ASPECT_EMITTER);
    }

    public static boolean isAspectReceiver(BlockState blockState) {
        return blockState.is(RailcraftTags.Blocks.ASPECT_RECEIVER);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, WEST, SOUTH, CAP, WATERLOGGED});
    }

    protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.block();
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean isMoving) {
        LevelUtil.getBlockEntity((BlockGetter)level, pos, AbstractSignalBoxBlockEntity.class).ifPresent(AbstractSignalBoxBlockEntity::neighborChanged);
    }

    protected boolean isSignalSource(BlockState blockState) {
        return true;
    }

    protected int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return LevelUtil.getBlockEntity(level, pos, AbstractSignalBoxBlockEntity.class).map(blockEntity -> blockEntity.getRedstoneSignal(direction)).orElse(0);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        FluidState fluidState = level.getFluidState(pos);
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    protected BlockState updateShape(BlockState blockState, LevelReader levelReader, ScheduledTickAccess scheduledTickAccess, BlockPos blockPos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(levelReader));
        }
        return direction.getAxis().isHorizontal() ? (BlockState)blockState.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.attachesTo(blockState, neighborState))) : (direction == Direction.UP ? (BlockState)blockState.setValue((Property)CAP, (Comparable)Boolean.valueOf(!neighborState.isAir())) : blockState);
    }

    public boolean attachesTo(BlockState blockState, BlockState otherBlockState) {
        if (!SignalBoxBlock.isAspectEmitter(blockState) && !SignalBoxBlock.isAspectReceiver(blockState)) {
            return false;
        }
        return SignalBoxBlock.isAspectReceiver(blockState) && SignalBoxBlock.isAspectEmitter(otherBlockState) || SignalBoxBlock.isAspectEmitter(blockState) && SignalBoxBlock.isAspectReceiver(otherBlockState);
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter blockGetter, BlockPos pos) {
        return LevelUtil.getBlockEntity(blockGetter, pos, Lockable.class).filter(Lockable::isLocked).map(__ -> Float.valueOf(0.0f)).orElseGet(() -> Float.valueOf(super.getDestroyProgress(state, player, blockGetter, pos))).floatValue();
    }
}

