/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.tank;

import mods.railcraft.util.LevelUtil;
import mods.railcraft.world.level.block.AbstractStrengthenedGlassBlock;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockBlockEntity;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockListener;
import mods.railcraft.world.level.block.entity.tank.TankBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class TankGaugeBlock
extends AbstractStrengthenedGlassBlock
implements EntityBlock {
    public static final IntegerProperty LEVEL = BlockStateProperties.LEVEL;

    public TankGaugeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(TYPE, (Comparable)((Object)AbstractStrengthenedGlassBlock.Type.SINGLE))).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LEVEL});
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener getListener(ServerLevel level, T blockEntity) {
        MultiblockListener multiblockListener;
        if (blockEntity instanceof MultiblockBlockEntity) {
            MultiblockBlockEntity multiblock = (MultiblockBlockEntity)blockEntity;
            multiblockListener = new MultiblockListener(multiblock);
        } else {
            multiblockListener = null;
        }
        return multiblockListener;
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        return LevelUtil.getBlockEntity((BlockGetter)level, pos, TankBlockEntity.class).flatMap(MultiblockBlockEntity::getMembership).map(MultiblockBlockEntity.Membership::master).map(master -> {
            master.use((ServerPlayer)player, hand);
            return InteractionResult.CONSUME;
        }).orElse((InteractionResult)InteractionResult.TRY_WITH_EMPTY_HAND);
    }
}

