/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.item.SpikeMaulTarget;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.api.track.TypedTrack;
import mods.railcraft.world.item.SpikeMaulItem;
import mods.railcraft.world.level.block.track.RailcraftState;
import mods.railcraft.world.level.block.track.behaivor.TrackSupportTools;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TrackBlock
extends BaseRailBlock
implements TypedTrack,
ChargeBlock,
SpikeMaulTarget {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.RAIL_SHAPE;
    private static final Map<Charge, ChargeBlock.Spec> CHARGE_SPECS = ChargeBlock.Spec.make(Charge.distribution, ChargeBlock.ConnectType.TRACK, 0.01f);
    private final Supplier<? extends TrackType> trackType;

    public TrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(false, properties);
        this.trackType = trackType;
        this.registerDefaultState(this.buildDefaultState((BlockState)this.stateDefinition.any()));
    }

    protected MapCodec<? extends BaseRailBlock> codec() {
        return TrackBlock.simpleCodec(properties -> new TrackBlock(this.trackType, (BlockBehaviour.Properties)properties));
    }

    @Override
    public TrackType getTrackType() {
        return this.trackType.get();
    }

    public Property<RailShape> getShapeProperty() {
        return SHAPE;
    }

    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)((BlockState)blockState.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_SOUTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.getShapeProperty(), WATERLOGGED});
    }

    @Override
    public List<? extends Supplier<? extends Block>> getSpikeMaulVariants() {
        return this.trackType.get().getSpikeMaulVariants();
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        if (this.getTrackType().isElectric()) {
            this.registerNode(state, level, pos);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (this.getTrackType().isElectric()) {
            Charge.zapEffectProvider().throwSparks(state, level, pos, rand, 75);
        }
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        if (context.getItemInHand().getItem() instanceof SpikeMaulItem) {
            return true;
        }
        return super.canBeReplaced(state, context);
    }

    public void onPlace(BlockState blockState, Level level, BlockPos pos, BlockState oldBlockState, boolean moved) {
        super.onPlace(blockState, level, pos, oldBlockState, moved);
        if (!blockState.is(oldBlockState.getBlock())) {
            if (!TrackSupportTools.isSupported((LevelReader)level, pos, this.getMaxSupportedDistance())) {
                level.destroyBlock(pos, true);
                return;
            }
            if (this.getTrackType().isElectric()) {
                this.registerNode(blockState, (ServerLevel)level, pos);
            }
        }
    }

    public BlockState updateDir(Level level, BlockPos pos, BlockState state, boolean alwaysPlace) {
        if (level.isClientSide()) {
            return state;
        }
        RailShape railshape = (RailShape)state.getValue(this.getShapeProperty());
        return new RailcraftState(level, pos, state).place(level.hasNeighborSignal(pos), alwaysPlace, railshape).getState();
    }

    protected void affectNeighborsAfterRemoval(BlockState blockState, ServerLevel level, BlockPos pos, boolean movedByPiston) {
        super.affectNeighborsAfterRemoval(blockState, level, pos, movedByPiston);
        if (this.getTrackType().isElectric()) {
            this.deregisterNode(level, pos);
        }
    }

    @Override
    public Map<Charge, ChargeBlock.Spec> getChargeSpecs(BlockState state, ServerLevel level, BlockPos pos) {
        return this.getTrackType().isElectric() ? CHARGE_SPECS : Collections.emptyMap();
    }

    public int getMaxSupportedDistance() {
        return this.getTrackType().getMaxSupportDistance();
    }

    protected boolean isRailValid(BlockState state, Level level, BlockPos pos, int maxSupportedDistance) {
        RailShape railShape = TrackUtil.getRailShapeRaw(state);
        if (!TrackSupportTools.isSupported((LevelReader)level, pos, maxSupportedDistance)) {
            return false;
        }
        if (maxSupportedDistance == 0) {
            if (railShape == RailShape.ASCENDING_EAST && !TrackBlock.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.east())) {
                return false;
            }
            if (railShape == RailShape.ASCENDING_WEST && !TrackBlock.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.west())) {
                return false;
            }
            if (railShape == RailShape.ASCENDING_NORTH && !TrackBlock.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.north())) {
                return false;
            }
            if (railShape == RailShape.ASCENDING_SOUTH && !TrackBlock.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.south())) {
                return false;
            }
        }
        return true;
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean moved) {
        if (level.isClientSide()) {
            return;
        }
        if (!this.isRailValid(blockState, level, pos, this.getMaxSupportedDistance())) {
            level.destroyBlock(pos, true);
            return;
        }
        this.updateState(blockState, level, pos, neighborBlock);
        TrackUtil.traverseConnectedTracks(level, pos, (l, p) -> {
            BlockState state = l.getBlockState(p);
            Block block = state.getBlock();
            if (!BaseRailBlock.isRail((BlockState)state)) {
                return false;
            }
            if (block instanceof TrackBlock) {
                TrackBlock track = (TrackBlock)block;
                int maxSupportedDistance = track.getMaxSupportedDistance();
                if (maxSupportedDistance <= 0 || TrackSupportTools.isSupportedDirectly((BlockGetter)l, p)) {
                    return false;
                }
                if (!track.isRailValid(state, (Level)l, (BlockPos)p, maxSupportedDistance)) {
                    l.destroyBlock(p, true);
                    return false;
                }
            }
            return true;
        });
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        this.getTrackType().getEventHandler().minecartPass(level, cart, pos);
    }

    public RailShape getRailDirection(BlockState state, BlockGetter blockGetter, BlockPos pos, @Nullable AbstractMinecart cart) {
        return this.getTrackType().getEventHandler().getRailShapeOverride(blockGetter, pos, state, cart).orElseGet(() -> super.getRailDirection(state, blockGetter, pos, cart));
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean isInside) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.getTrackType().getEventHandler().entityInside(serverLevel, pos, state, entity);
        }
    }

    public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        return (float)this.getTrackType().getEventHandler().getMaxSpeed(level, cart, pos);
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return TrackSupportTools.isSupportedDirectly(blockGetter, pos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !BaseRailBlock.isRail((BlockState)level.getBlockState(pos.above())) && !BaseRailBlock.isRail((BlockState)level.getBlockState(pos.below())) && TrackSupportTools.isSupported(level, pos, this.getMaxSupportedDistance());
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        RailShape railShape = blockState.is((Block)this) ? (RailShape)blockState.getValue(this.getShapeProperty()) : null;
        return railShape != null && railShape.isSlope() ? SHAPE_SLOPE : SHAPE_FLAT;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                switch ((RailShape)state.getValue(this.getShapeProperty())) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_SOUTH: 
                    case EAST_WEST: {
                        return state;
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch ((RailShape)state.getValue(this.getShapeProperty())) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch ((RailShape)state.getValue(this.getShapeProperty())) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.setValue(this.getShapeProperty(), (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
        }
        return state;
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        Property<RailShape> shape = this.getShapeProperty();
        RailShape railshape = (RailShape)state.getValue(shape);
        block0 : switch (mirror) {
            case LEFT_RIGHT: {
                switch (railshape) {
                    case ASCENDING_NORTH: {
                        return (BlockState)state.setValue(shape, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.setValue(shape, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.setValue(shape, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.setValue(shape, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.setValue(shape, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.setValue(shape, (Comparable)RailShape.SOUTH_EAST);
                    }
                }
                return super.mirror(state, mirror);
            }
            case FRONT_BACK: {
                switch (railshape) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.setValue(shape, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.setValue(shape, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.setValue(shape, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.setValue(shape, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.setValue(shape, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return (BlockState)state.setValue(shape, (Comparable)RailShape.NORTH_WEST);
            }
        }
        return super.mirror(state, mirror);
    }

    public static RailShape getRailShapeRaw(BlockState state) {
        return (RailShape)state.getValue(((BaseRailBlock)state.getBlock()).getShapeProperty());
    }
}

