/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.function.Supplier;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.level.block.track.outfitted.ReversiblePoweredOutfittedTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public class OneWayTrackBlock
extends ReversiblePoweredOutfittedTrackBlock {
    private static final double LOSS_FACTOR = 0.49;

    public OneWayTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        if (!OneWayTrackBlock.isPowered(state)) {
            return;
        }
        Vec3 deltaMovement = cart.getDeltaMovement();
        RailShape railShape = OneWayTrackBlock.getRailShapeRaw(state);
        if (RailShapeUtil.isEastWest(railShape)) {
            if (OneWayTrackBlock.isReversed(state) ? deltaMovement.x() > 0.0 : deltaMovement.x() < 0.0) {
                double distX = cart.getX() - ((double)pos.getX() + 0.5);
                if (OneWayTrackBlock.isReversed(state) ? distX > 0.01 : distX < -0.01) {
                    cart.setPos((double)pos.getX() + 0.5, cart.getY(), cart.getZ());
                }
                double deltaX = OneWayTrackBlock.isReversed(state) ? -Math.abs(deltaMovement.x()) * 0.49 : Math.abs(deltaMovement.x()) * 0.49;
                cart.setDeltaMovement(deltaX, deltaMovement.y(), deltaMovement.z());
            }
        } else if (RailShapeUtil.isNorthSouth(railShape) && (OneWayTrackBlock.isReversed(state) ? deltaMovement.z() < 0.0 : deltaMovement.z() > 0.0)) {
            double distZ = cart.getZ() - ((double)pos.getZ() + 0.5);
            if (OneWayTrackBlock.isReversed(state) ? distZ < -0.01 : distZ > 0.01) {
                cart.setPos(cart.getX(), cart.getY(), (double)pos.getZ() + 0.5);
            }
            double deltaZ = OneWayTrackBlock.isReversed(state) ? Math.abs(deltaMovement.z()) * 0.49 : -Math.abs(deltaMovement.z()) * 0.49;
            cart.setDeltaMovement(deltaMovement.x(), deltaMovement.y(), deltaZ);
        }
    }
}

