/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.worldspike;

import mods.railcraft.Translations;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.worldspike.PersonalWorldSpikeBlockEntity;
import mods.railcraft.world.level.block.entity.worldspike.WorldSpikeBlockEntity;
import mods.railcraft.world.level.block.worldspike.WorldSpikeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class PersonalWorldSpikeBlock
extends WorldSpikeBlock {
    public PersonalWorldSpikeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PersonalWorldSpikeBlockEntity) {
            PersonalWorldSpikeBlockEntity worldSpike = (PersonalWorldSpikeBlockEntity)blockEntity;
            if (placer instanceof Player) {
                Player player = (Player)placer;
                worldSpike.setOwner(player.nameAndId());
            }
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, ItemStack toolStack, boolean willHarvest, FluidState fluid) {
        PersonalWorldSpikeBlockEntity worldSpike;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PersonalWorldSpikeBlockEntity && ((worldSpike = (PersonalWorldSpikeBlockEntity)blockEntity).getOwner().isEmpty() || worldSpike.isOwnerOrOperator(player.nameAndId()))) {
            return super.onDestroyedByPlayer(state, level, pos, player, toolStack, willHarvest, fluid);
        }
        return false;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new PersonalWorldSpikeBlockEntity(blockPos, blockState);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.isClientSide() ? null : PersonalWorldSpikeBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.PERSONAL_WORLD_SPIKE.get()), WorldSpikeBlockEntity::serverTick);
    }

    @Override
    public Component jeiDescription() {
        return Component.translatable((String)Translations.Jei.PERSONAL_WORLD_SPIKE);
    }
}

