/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.levelgen.structure;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Optional;
import mods.railcraft.api.core.RailcraftConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class ComponentWorkshop {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"empty"));

    private static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation templatePoolName, ResourceLocation newStructureName, int frequency) {
        Holder.Reference emptyProcessorList = processorListRegistry.getOrThrow(EMPTY_PROCESSOR_LIST_KEY);
        Optional optionalPool = templatePoolRegistry.get(templatePoolName);
        if (optionalPool.isEmpty()) {
            return;
        }
        StructureTemplatePool pool = (StructureTemplatePool)((Holder.Reference)optionalPool.get()).value();
        LegacySinglePoolElement piece = (LegacySinglePoolElement)SinglePoolElement.legacy((String)newStructureName.toString(), (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < frequency; ++i) {
            pool.templates.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.rawTemplates);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)frequency));
        pool.rawTemplates = listOfPieceEntries;
    }

    public static void addVillageStructures(RegistryAccess.Frozen registryAccess) {
        Registry templatePoolRegistry = (Registry)registryAccess.lookup(Registries.TEMPLATE_POOL).orElseThrow();
        Registry processorListRegistry = (Registry)registryAccess.lookup(Registries.PROCESSOR_LIST).orElseThrow();
        ComponentWorkshop.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/plains/houses"), RailcraftConstants.rl("component_workshop_cartman"), 4);
        ComponentWorkshop.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/plains/houses"), RailcraftConstants.rl("component_workshop_trackman"), 6);
    }
}

