/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.material;

import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.CreosoteLiquidBlock;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.material.RailcraftFluidTypes;
import mods.railcraft.world.level.material.RailcraftFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class CreosoteFluid
extends FlowingFluid {
    public Fluid getFlowing() {
        return (Fluid)RailcraftFluids.FLOWING_CREOSOTE.get();
    }

    public Fluid getSource() {
        return (Fluid)RailcraftFluids.CREOSOTE.get();
    }

    public Item getBucket() {
        return (Item)RailcraftItems.CREOSOTE_BUCKET.get();
    }

    protected int getSlopeFindDistance(LevelReader levelReader) {
        return 4;
    }

    protected BlockState createLegacyBlock(FluidState fluidState) {
        return (BlockState)((CreosoteLiquidBlock)((Object)RailcraftBlocks.CREOSOTE.get())).defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(CreosoteFluid.getLegacyLevel((FluidState)fluidState)));
    }

    public boolean isSame(Fluid fluid) {
        return fluid == RailcraftFluids.FLOWING_CREOSOTE.get() || fluid == RailcraftFluids.CREOSOTE.get();
    }

    protected int getDropOff(LevelReader levelReader) {
        return 1;
    }

    public int getTickDelay(LevelReader levelReader) {
        return 5;
    }

    public boolean canBeReplacedWith(FluidState fluidState, BlockGetter blockGetter, BlockPos blockPos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !this.isSame(fluid);
    }

    protected float getExplosionResistance() {
        return 50.0f;
    }

    public Vec3 getFlow(BlockGetter blockGetter, BlockPos blockPos, FluidState fluidState) {
        return Vec3.ZERO;
    }

    public FluidType getFluidType() {
        return RailcraftFluidTypes.CREOSOTE.get();
    }

    public boolean canConvertToSource(FluidState state, ServerLevel level, BlockPos pos) {
        return false;
    }

    protected void beforeDestroyingBlock(LevelAccessor level, BlockPos blockPos, BlockState blockState) {
        BlockEntity blockEntity = blockState.hasBlockEntity() ? level.getBlockEntity(blockPos) : null;
        Block.dropResources((BlockState)blockState, (LevelAccessor)level, (BlockPos)blockPos, (BlockEntity)blockEntity);
    }

    public static class Source
    extends CreosoteFluid {
        public int getAmount(FluidState fluidState) {
            return 8;
        }

        public boolean isSource(FluidState fluidState) {
            return true;
        }

        protected boolean canConvertToSource(ServerLevel level) {
            return true;
        }
    }

    public static class Flowing
    extends CreosoteFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> fluidState) {
            super.createFluidStateDefinition(fluidState);
            fluidState.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState fluidState) {
            return (Integer)fluidState.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState fluidState) {
            return false;
        }

        protected boolean canConvertToSource(ServerLevel level) {
            return false;
        }
    }
}

