/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.material;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import mods.railcraft.world.level.material.StandardTank;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class TankManager
implements ResourceHandler<FluidResource>,
ValueIOSerializable {
    public static final TankManager EMPTY = new TankManager(List.of());
    public static final BiFunction<BlockEntity, Direction, Boolean> TANK_FILTER = (be, dir) -> be.getLevel().getCapability(Capabilities.Fluid.BLOCK, be.getBlockPos(), dir) != null;
    private final List<StandardTank> tanks;

    public TankManager(StandardTank ... tanks) {
        this(new ArrayList<StandardTank>(Arrays.asList(tanks)));
    }

    private TankManager(List<StandardTank> tanks) {
        this.tanks = tanks;
    }

    public boolean add(StandardTank tank) {
        return this.tanks.add(tank);
    }

    public void serialize(ValueOutput valueOutput) {
        ValueOutput.ValueOutputList list = valueOutput.childrenList("tank");
        for (int i = 0; i < this.tanks.size(); ++i) {
            ValueOutput tankOutput = list.addChild();
            tankOutput.putInt("index", i);
            this.tanks.get(i).serialize(tankOutput);
        }
    }

    public void deserialize(ValueInput valueInput) {
        ValueInput.ValueInputList list = valueInput.childrenListOrEmpty("tank");
        list.forEach(input -> {
            int index = input.getIntOr("index", -1);
            if (index >= 0 && index < this.tanks.size()) {
                this.tanks.get(index).deserialize((ValueInput)input);
            }
        });
    }

    public void writePacketData(RegistryFriendlyByteBuf data) {
        for (StandardTank tank : this.tanks) {
            FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)data, (Object)tank.getFluidStack());
        }
    }

    public void readPacketData(RegistryFriendlyByteBuf data) {
        for (StandardTank tank : this.tanks) {
            tank.setFluid((FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)data));
        }
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        return this.tanks.get(index).insert(0, (Resource)resource, amount, transaction);
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        return this.tanks.get(index).extract(0, (Resource)resource, amount, transaction);
    }

    public StandardTank get(int tankIndex) {
        return this.tanks.get(tankIndex);
    }

    public void setCapacity(int tankIndex, int capacity) {
        StandardTank tank = this.get(tankIndex);
        tank.setCapacity(capacity);
        FluidStack fluidStack = tank.getFluidStack();
        if (fluidStack.getAmount() > capacity) {
            fluidStack.setAmount(capacity);
        }
    }

    public void pull(Collection<ResourceHandler<FluidResource>> targets, int tankIndex, int amount) {
        this.transfer(targets, tankIndex, (me, them) -> ResourceHandlerUtil.move((ResourceHandler)them, (ResourceHandler)me, (Predicate)Predicates.alwaysTrue(), (int)amount, null));
    }

    public void push(Collection<ResourceHandler<FluidResource>> targets, int tankIndex, int amount) {
        this.transfer(targets, tankIndex, (me, them) -> ResourceHandlerUtil.move((ResourceHandler)me, (ResourceHandler)them, (Predicate)Predicates.alwaysTrue(), (int)amount, null));
    }

    public void transfer(Collection<ResourceHandler<FluidResource>> targets, int tankIndex, BiConsumer<ResourceHandler<FluidResource>, ResourceHandler<FluidResource>> transfer) {
        targets.forEach(them -> transfer.accept((ResourceHandler<FluidResource>)this.get(tankIndex), (ResourceHandler<FluidResource>)them));
    }

    public int size() {
        return this.tanks.size();
    }

    public FluidResource getResource(int index) {
        return (FluidResource)this.tanks.get(1).getResource(0);
    }

    public long getAmountAsLong(int index) {
        return this.tanks.get(index).getAmountAsLong(0);
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        return this.tanks.get(index).getCapacityAsLong(0, (Resource)resource);
    }

    public boolean isValid(int index, FluidResource resource) {
        return this.tanks.get(index).isValid(0, resource);
    }
}

