/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.material.steam;

import mods.railcraft.util.FuelUtil;
import mods.railcraft.world.level.material.FuelProvider;
import mods.railcraft.world.level.material.StandardTank;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class FluidFuelProvider
implements FuelProvider {
    private final StandardTank fuelTank;

    public FluidFuelProvider(StandardTank fuelTank) {
        this.fuelTank = fuelTank;
    }

    @Override
    public float getHeatStep() {
        return 0.05f;
    }

    @Override
    public float consumeFuel() {
        try (Transaction tx = Transaction.openRoot();){
            FluidResource fuelResource = (FluidResource)this.fuelTank.getResource(0);
            if (fuelResource.isEmpty()) {
                float f = 0.0f;
                return f;
            }
            int fuelExtracted = this.fuelTank.internalExtract(fuelResource, 1000, (TransactionContext)tx);
            if (fuelExtracted == 0) {
                float f = 0.0f;
                return f;
            }
            float heatValue = FuelUtil.getFuelValueForSize(new FluidStack(fuelResource.getFluid(), fuelExtracted));
            if (heatValue > 0.0f) {
                tx.commit();
            }
            float f = heatValue;
            return f;
        }
    }
}

