/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.item.crafting.CokeOvenRecipe;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.entity.CokeOvenBlockEntity;
import mods.railcraft.world.level.material.RailcraftFluids;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.CookingModule;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.DelegatingResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class CokeOvenModule
extends CookingModule<CokeOvenRecipe, CokeOvenBlockEntity> {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int SLOT_LIQUID_INPUT = 2;
    public static final int SLOT_LIQUID_PROCESSING = 3;
    public static final int SLOT_LIQUID_OUTPUT = 4;
    private final ContainerMapper outputContainer;
    private int multiplier = 1;
    private final StandardTank tank;
    private int fluidProcessingTimer;
    private FluidTools.ProcessState processState = FluidTools.ProcessState.RESET;
    private final ContainerMapper fluidContainer;
    private final ResourceHandler<ItemResource> itemHandler;

    public CokeOvenModule(CokeOvenBlockEntity provider) {
        super(provider, 5, 0);
        this.tank = StandardTank.ofBuckets(64).disableInsert().changeCallback(this::setChanged);
        this.outputContainer = ContainerMapper.make(this, 1, 1).ignoreItemChecks();
        this.fluidContainer = ContainerMapper.make(this, 2, 4);
        this.itemHandler = new DelegatingResourceHandler<ItemResource>(this, VanillaContainerWrapper.of((Container)this)){

            public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
                if (index == 0) {
                    return 0;
                }
                return super.extract(index, (Resource)resource, amount, transaction);
            }

            public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
                if (index == 0) {
                    return super.insert(index, (Resource)resource, amount, transaction);
                }
                return 0;
            }
        };
    }

    @Override
    protected RecipeType<CokeOvenRecipe> getRecipeType() {
        return (RecipeType)RailcraftRecipeTypes.COKING.get();
    }

    @Override
    protected boolean craftAndPush() {
        boolean crafted = false;
        for (int i = 0; i < this.multiplier; ++i) {
            crafted |= this.craftAndPushImp();
        }
        return crafted;
    }

    private boolean craftAndPushImp() {
        ItemStack output = ((CokeOvenRecipe)this.recipe).assemble(null, (HolderLookup.Provider)((CokeOvenBlockEntity)this.provider).level().registryAccess());
        FluidStack fluidOutput = ((CokeOvenRecipe)this.recipe).getCreosote();
        if (!this.outputContainer.canFit(output)) {
            return false;
        }
        try (Transaction tx = Transaction.openRoot();){
            if (fluidOutput.isEmpty() || this.tank.internalInsert(FluidResource.of((FluidStack)fluidOutput), fluidOutput.getAmount(), (TransactionContext)tx) >= fluidOutput.getAmount()) {
                this.removeItem(0, 1);
                this.outputContainer.insert(output);
                tx.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public void serverTick() {
        ItemStack bottomSlot;
        super.serverTick();
        ItemStack topSlot = this.getItem(2);
        if (!topSlot.isEmpty() && !FluidTools.isFluidHandler(topSlot)) {
            this.setItem(2, ItemStack.EMPTY);
            ((CokeOvenBlockEntity)this.provider).dropItem(topSlot);
        }
        if (!(bottomSlot = this.getItem(4)).isEmpty() && !FluidTools.isFluidHandler(bottomSlot)) {
            this.setItem(4, ItemStack.EMPTY);
            ((CokeOvenBlockEntity)this.provider).dropItem(bottomSlot);
        }
        if (this.fluidProcessingTimer++ >= 8) {
            this.fluidProcessingTimer = 0;
            this.processState = FluidTools.processContainer(this.fluidContainer, this.tank, FluidTools.ProcessType.FILL_ONLY, this.processState);
        }
    }

    public boolean needsFuel() {
        return this.getItem(0).getCount() < 8;
    }

    public StandardTank getTank() {
        return this.tank;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canPlaceItem(int slot, ItemStack itemStack) {
        switch (slot) {
            case 0: {
                if (!this.getRecipeFor(itemStack).isPresent()) return false;
                break;
            }
            case 2: {
                if (!FluidTools.isRoomInContainer(itemStack, (Fluid)RailcraftFluids.CREOSOTE.get())) return false;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                return false;
            }
        }
        if (!super.canPlaceItem(slot, itemStack)) return false;
        return true;
    }

    public ResourceHandler<ItemResource> getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public void serialize(ValueOutput valueOutput) {
        super.serialize(valueOutput);
        valueOutput.putChild("tank", (ValueIOSerializable)this.tank);
        valueOutput.store("processState", FluidTools.ProcessState.CODEC, (Object)this.processState);
    }

    @Override
    public void deserialize(ValueInput valueInput) {
        super.deserialize(valueInput);
        valueInput.readChild("tank", (ValueIOSerializable)this.tank);
        this.processState = valueInput.read("processState", FluidTools.ProcessState.CODEC).orElse(FluidTools.ProcessState.RESET);
    }
}

