/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.world.module.ContainerModule;
import mods.railcraft.world.module.ModuleProvider;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class CrafterModule<T extends ModuleProvider>
extends ContainerModule<T> {
    protected static final int PROGRESS_STEP = 16;
    protected int progress;
    protected int duration;
    private boolean processing;
    protected boolean paused;
    private long finishedAt;
    private int progressStepTicks;

    protected CrafterModule(T provider, int size) {
        super(provider, size);
    }

    @Override
    public void serverTick() {
        if (this.progressStepTicks++ >= 16) {
            this.progressStepTicks = 0;
            this.progressCrafting();
        }
    }

    public final int getProgress() {
        return this.progress;
    }

    public final void setProgress(int progress) {
        this.progress = progress;
    }

    protected void reset() {
        this.setProgress(0);
        this.setProcessing(false);
        this.provider.syncToClient();
    }

    public final boolean isProcessing() {
        return this.processing;
    }

    protected final void setProcessing(boolean processing) {
        if (this.processing != processing) {
            this.processing = processing;
            this.provider.syncToClient();
        }
    }

    public final void setDuration(int duration) {
        this.duration = duration;
    }

    public final int getDuration() {
        return this.duration;
    }

    protected abstract int calculateDuration();

    protected final void setFinished() {
        this.finishedAt = this.provider.level().getGameTime();
    }

    protected final boolean isFinished() {
        return this.processing && this.provider.level().getGameTime() > this.finishedAt + 16L + 5L;
    }

    public final float getProgressPercent() {
        if (this.getProgress() == 0 || this.getDuration() == 0) {
            return 0.0f;
        }
        return (float)this.getProgress() / (float)this.getDuration();
    }

    protected void setupCrafting() {
    }

    protected boolean lacksRequirements() {
        return false;
    }

    protected boolean doProcessStep() {
        return true;
    }

    protected final void progressCrafting() {
        if (this.isFinished()) {
            this.setProcessing(false);
        }
        if (this.paused) {
            return;
        }
        this.setupCrafting();
        if (this.lacksRequirements()) {
            this.reset();
            return;
        }
        this.setProcessing(true);
        if (this.doProcessStep()) {
            this.progress += 16;
            this.duration = this.calculateDuration();
            if (this.progress < this.duration) {
                return;
            }
            this.progress = this.duration;
            this.setFinished();
            if (this.craftAndPush()) {
                this.reset();
            }
        }
    }

    protected abstract boolean craftAndPush();

    @Override
    public void serialize(ValueOutput valueOutput) {
        super.serialize(valueOutput);
        valueOutput.putInt("progress", this.progress);
        valueOutput.putBoolean("processing", this.processing);
    }

    @Override
    public void deserialize(ValueInput valueInput) {
        super.deserialize(valueInput);
        this.progress = valueInput.getIntOr("progress", 0);
        this.processing = valueInput.getBooleanOr("processing", false);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf out) {
        super.writeToBuf(out);
        out.writeBoolean(this.processing);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf in) {
        super.readFromBuf(in);
        this.processing = in.readBoolean();
    }
}

