/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.signal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mods.railcraft.world.signal.SimpleTokenRing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class TokenRingManager
extends SavedData {
    private static final Codec<Map<String, TokenRingData>> MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, TokenRingData.CODEC);
    private static final SavedDataType<TokenRingManager> TYPE = new SavedDataType("railcraft.tokens", TokenRingManager::new, ctx -> RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)ctx.levelOrThrow()), (App)MAP_CODEC.fieldOf("tokenRings").forGetter(manager -> TokenRingManager.from(manager.tokenRings))).apply((Applicative)instance, TokenRingManager::new)));
    private final ServerLevel level;
    private final Map<UUID, SimpleTokenRing> tokenRings = new HashMap<UUID, SimpleTokenRing>();
    private int clock;

    private TokenRingManager(SavedData.Context context) {
        this.level = context.levelOrThrow();
    }

    private TokenRingManager(ServerLevel level, Map<String, TokenRingData> tokenRings) {
        this.level = level;
        for (Map.Entry<String, TokenRingData> entry : tokenRings.entrySet()) {
            UUID id = UUID.fromString(entry.getKey());
            SimpleTokenRing tokenRing = new SimpleTokenRing(this.level, this, id);
            tokenRing.loadSignals(entry.getValue().signals);
            tokenRing.loadCarts(entry.getValue().carts);
            this.tokenRings.put(id, tokenRing);
        }
    }

    private static Map<String, TokenRingData> from(Map<UUID, SimpleTokenRing> tokenRings) {
        HashMap<String, TokenRingData> result = new HashMap<String, TokenRingData>();
        for (Map.Entry<UUID, SimpleTokenRing> entry : tokenRings.entrySet()) {
            UUID id = entry.getKey();
            SimpleTokenRing simpleTokenRing = entry.getValue();
            ArrayList<BlockPos> signals = new ArrayList<BlockPos>(simpleTokenRing.peers());
            ArrayList<UUID> carts = new ArrayList<UUID>(simpleTokenRing.getTrackedCarts());
            result.put(id.toString(), new TokenRingData(id, signals, carts));
        }
        return result;
    }

    public void tick(ServerLevel level) {
        ++this.clock;
        if (this.clock >= 32) {
            this.clock = 0;
            if (this.tokenRings.entrySet().removeIf(e -> ((SimpleTokenRing)e.getValue()).isOrphaned(level))) {
                this.setDirty();
            }
            this.tokenRings.values().forEach(SimpleTokenRing::tick);
        }
    }

    public SimpleTokenRing getTokenRingNetwork(UUID id, BlockPos origin) {
        return this.tokenRings.computeIfAbsent(id, __ -> new SimpleTokenRing(this.level, this, id, origin));
    }

    public static TokenRingManager get(ServerLevel level) {
        return (TokenRingManager)level.getDataStorage().computeIfAbsent(TYPE);
    }

    private record TokenRingData(UUID id, List<BlockPos> signals, List<UUID> carts) {
        public static final Codec<TokenRingData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("id").forGetter(TokenRingData::id), (App)BlockPos.CODEC.listOf().fieldOf("signals").forGetter(TokenRingData::signals), (App)UUIDUtil.CODEC.listOf().fieldOf("carts").forGetter(TokenRingData::carts)).apply((Applicative)instance, TokenRingData::new));
    }
}

