/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signal;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import mods.railcraft.api.signal.BlockEntitySignalNetwork;
import mods.railcraft.api.signal.BlockSignal;
import mods.railcraft.api.signal.BlockSignalEntity;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.SignalUtil;
import mods.railcraft.api.signal.TrackLocator;
import mods.railcraft.api.track.TrackScanUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SimpleBlockSignalNetwork
extends BlockEntitySignalNetwork<BlockSignalEntity>
implements BlockSignal {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int SIGNAL_VALIDATION_INTERVAL = 4800;
    private final Set<BlockPos> signalsToRevalidate = new HashSet<BlockPos>();
    private final Map<BlockPos, TrackScanUtil.Result> trackScans = new HashMap<BlockPos, TrackScanUtil.Result>();
    private final TrackLocator trackLocator;
    private int aspectUpdateTimer = 0;
    private int signalValidationTimer = 0;
    private SignalAspect signalAspect = SignalAspect.BLINK_RED;
    @Nullable
    private final Consumer<SignalAspect> signalAspectListener;

    public SimpleBlockSignalNetwork(int maxPeers, Runnable syncListener, @Nullable Consumer<SignalAspect> signalAspectListener, BlockEntity blockEntity) {
        super(BlockSignalEntity.class, maxPeers, syncListener, blockEntity);
        this.trackLocator = new TrackLocator(() -> ((BlockEntity)blockEntity).getLevel(), blockEntity.getBlockPos());
        this.signalAspectListener = signalAspectListener;
    }

    @Override
    public SignalAspect aspect() {
        return this.signalAspect;
    }

    @Override
    public TrackLocator trackLocator() {
        return this.trackLocator;
    }

    @Override
    public boolean addPeer(BlockSignalEntity peer) {
        BlockSignal blockSignal = peer.signalNetwork();
        if (blockSignal == this) {
            return false;
        }
        TrackLocator.Status trackStatus = this.trackLocator.trackStatus();
        TrackLocator.Status otherTrackStatus = blockSignal.trackLocator().trackStatus();
        if (trackStatus.invalid() || otherTrackStatus.invalid()) {
            return false;
        }
        BlockPos trackPos = this.trackLocator.trackPos();
        BlockPos peerTrackPos = blockSignal.trackLocator().trackPos();
        assert (trackPos != null);
        assert (peerTrackPos != null);
        TrackScanUtil.Result result = TrackScanUtil.scanStraightTrackSection(this.getLevel(), trackPos, peerTrackPos);
        if (!result.status().valid()) {
            return false;
        }
        if (!super.addPeer(peer)) {
            return false;
        }
        this.trackScans.put(peerTrackPos, result);
        return true;
    }

    @Override
    public boolean removePeer(BlockPos peerPos) {
        if (super.removePeer(peerPos)) {
            BlockSignalEntity blockSignalProvider = (BlockSignalEntity)this.getBlockEntity(peerPos);
            if (blockSignalProvider != null) {
                blockSignalProvider.signalNetwork().removePeer(this.blockPos());
            }
            return true;
        }
        return false;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.signalAspectListener != null) {
            this.signalAspectListener.accept(this.signalAspect);
        }
    }

    @Override
    protected boolean refreshPeer(BlockSignalEntity peer) {
        return peer.signalNetwork().isPeer(this.blockPos());
    }

    @Override
    public SignalAspect aspectExcluding(BlockPos excludingPos) {
        return this.stream().filter(peer -> !peer.asBlockEntity().getBlockPos().equals((Object)excludingPos)).map(this::calculateSignalAspect).reduce(SignalAspect.GREEN, SignalAspect::mostRestrictive);
    }

    private SignalAspect calculateSignalAspect(BlockSignalEntity peer) {
        BlockPos trackPos = this.trackLocator.trackPos();
        if (trackPos == null) {
            return SignalAspect.RED;
        }
        BlockPos otherTrack = peer.signalNetwork().trackLocator().trackPos();
        if (otherTrack == null) {
            return SignalAspect.YELLOW;
        }
        TrackScanUtil.Result scan = this.getOrCreateTrackScan(otherTrack);
        if (scan == null) {
            return SignalAspect.RED;
        }
        int y1 = scan.minY();
        int y2 = scan.maxY() + 1;
        int x1 = Math.min(trackPos.getX(), otherTrack.getX());
        int z1 = Math.min(trackPos.getZ(), otherTrack.getZ());
        int x2 = Math.max(trackPos.getX(), otherTrack.getX()) + 1;
        int z2 = Math.max(trackPos.getZ(), otherTrack.getZ()) + 1;
        boolean zAxis = Math.abs(trackPos.getX() - otherTrack.getX()) < Math.abs(trackPos.getZ() - otherTrack.getZ());
        int xOffset = otherTrack.getX() > trackPos.getX() ? -3 : 3;
        int zOffset = otherTrack.getZ() > trackPos.getZ() ? -3 : 3;
        List carts = this.getLevel().getEntitiesOfClass(AbstractMinecart.class, new AABB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2), EntitySelector.ENTITY_STILL_ALIVE);
        SignalAspect newAspect = SignalAspect.GREEN;
        for (AbstractMinecart cart : carts) {
            int cartX = Mth.floor((double)cart.getX());
            int cartZ = Mth.floor((double)cart.getZ());
            double motionX = cart.getDeltaMovement().x();
            double motionZ = cart.getDeltaMovement().z();
            if (Math.abs(motionX) < 0.08 && Math.abs(motionZ) < 0.08) {
                return SignalAspect.RED;
            }
            if (zAxis) {
                if (cartZ > trackPos.getZ() + zOffset && motionZ < 0.0) {
                    return SignalAspect.RED;
                }
                if (cartZ < trackPos.getZ() + zOffset && motionZ > 0.0) {
                    return SignalAspect.RED;
                }
            }
            if (cartX > trackPos.getX() + xOffset && motionX < 0.0) {
                return SignalAspect.RED;
            }
            if (cartX < trackPos.getX() + xOffset && motionX > 0.0) {
                return SignalAspect.RED;
            }
            newAspect = SignalAspect.YELLOW;
        }
        return SignalAspect.mostRestrictive(newAspect, peer.signalNetwork().aspectExcluding(this.blockPos()));
    }

    @Nullable
    private TrackScanUtil.Result getOrCreateTrackScan(BlockPos otherTrack) {
        BlockPos trackPos;
        TrackScanUtil.Result result = this.trackScans.get(otherTrack);
        if (result == null && (trackPos = this.trackLocator.trackPos()) != null) {
            result = TrackScanUtil.scanStraightTrackSection(this.getLevel(), trackPos, otherTrack);
            this.trackScans.put(otherTrack, result);
        }
        return result;
    }

    private TrackValidationResult validateSignal(BlockSignal blockSignal) {
        TrackLocator.Status trackStatus = this.trackLocator.trackStatus();
        if (trackStatus == TrackLocator.Status.INVALID) {
            return new TrackValidationResult(false, "INVALID_MY_TRACK_NULL");
        }
        TrackLocator.Status otherTrackStatus = blockSignal.trackLocator().trackStatus();
        if (otherTrackStatus == TrackLocator.Status.INVALID) {
            return new TrackValidationResult(false, "INVALID_OTHER_TRACK_INVALID");
        }
        BlockPos otherTrackPos = blockSignal.trackLocator().trackPos();
        if (otherTrackPos == null) {
            return new TrackValidationResult(true, "UNVERIFIABLE_OTHER_TRACK_NULL");
        }
        BlockPos trackPos = this.trackLocator.trackPos();
        if (trackPos == null) {
            return new TrackValidationResult(true, "INVALID_MY_TRACK_NULL");
        }
        TrackScanUtil.Result scanResult = TrackScanUtil.scanStraightTrackSection(this.getLevel(), trackPos, otherTrackPos);
        this.trackScans.put(otherTrackPos, scanResult);
        if (scanResult.status().valid()) {
            return new TrackValidationResult(true, "VALID");
        }
        if (scanResult.status().unknown()) {
            return new TrackValidationResult(true, "UNVERIFIABLE_UNLOADED_CHUNK");
        }
        return new TrackValidationResult(false, "INVALID_SCAN_FAIL: " + String.valueOf((Object)scanResult.status()));
    }

    public void serverTick() {
        if (this.aspectUpdateTimer++ >= SignalUtil.aspectUpdateInterval) {
            this.aspectUpdateTimer = 0;
            SignalAspect lastAspect = this.signalAspect;
            if (this.hasPeers()) {
                this.signalAspect = SignalAspect.GREEN;
                for (BlockPos peerPos : this.peers) {
                    this.peerAt(peerPos).ifPresent(peer -> {
                        this.signalAspect = SignalAspect.mostRestrictive(this.signalAspect, this.calculateSignalAspect((BlockSignalEntity)peer));
                    });
                }
            } else {
                this.signalAspect = this.isLinking() ? SignalAspect.BLINK_YELLOW : SignalAspect.BLINK_RED;
            }
            if (lastAspect != this.signalAspect && this.signalAspectListener != null) {
                this.signalAspectListener.accept(this.signalAspect);
            }
        }
        if (this.signalValidationTimer++ >= 4800) {
            this.signalValidationTimer = 0;
            switch (this.trackLocator.trackStatus()) {
                case INVALID: {
                    this.peers.clear();
                    LOGGER.debug("Block signal dropped because no track was found near signal @ [{}]", (Object)this.blockPos());
                    break;
                }
                case VALID: {
                    this.signalsToRevalidate.retainAll(this.peers());
                    for (BlockPos peerPos : this.signalsToRevalidate) {
                        this.peerAt(peerPos).ifPresentOrElse(peer -> {
                            TrackValidationResult result = this.validateSignal(peer.signalNetwork());
                            if (!result.valid) {
                                this.removePeer(peerPos);
                                LOGGER.debug("Block signal dropped because track between signals was invalid. source:[{}] target:[{}] reason:{}", new Object[]{this.blockPos(), peerPos, result.message});
                            }
                        }, this.peers::remove);
                    }
                    this.signalsToRevalidate.clear();
                    Iterator iterator = this.peers.iterator();
                    while (iterator.hasNext()) {
                        BlockPos peerPos;
                        peerPos = (BlockPos)iterator.next();
                        this.peerAt(peerPos).ifPresentOrElse(peer -> {
                            TrackValidationResult result = this.validateSignal(peer.signalNetwork());
                            if (!result.valid) {
                                this.signalsToRevalidate.add(peerPos);
                            }
                        }, iterator::remove);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeEnum((Enum)this.signalAspect);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        super.readFromBuf(data);
        this.signalAspect = (SignalAspect)data.readEnum(SignalAspect.class);
    }

    private record TrackValidationResult(boolean valid, String message) {
    }
}

