/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mods.railcraft.advancements.MinecartPredicate;
import mods.railcraft.advancements.RailcraftCriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.vehicle.AbstractMinecart;

public class CartLinkingTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public void trigger(ServerPlayer playerEntity, AbstractMinecart owned, AbstractMinecart other) {
        this.trigger(playerEntity, criterionInstance -> criterionInstance.matches(playerEntity, owned, other));
    }

    public static Criterion<TriggerInstance> hasLinked() {
        return RailcraftCriteriaTriggers.CART_LINK.createCriterion(new TriggerInstance(Optional.empty(), Optional.empty(), Optional.empty()));
    }

    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<MinecartPredicate> owned, Optional<MinecartPredicate> other) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)MinecartPredicate.CODEC.optionalFieldOf("owned").forGetter(TriggerInstance::owned), (App)MinecartPredicate.CODEC.optionalFieldOf("other").forGetter(TriggerInstance::other)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ServerPlayer player, AbstractMinecart owned, AbstractMinecart other) {
            return this.owned.map(x -> x.matches(player, owned)).orElse(true) != false && this.other.map(x -> x.matches(player, other)).orElse(true) != false;
        }
    }
}

