/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.charge;

import mods.railcraft.api.charge.Charge;
import mods.railcraft.particle.RailcraftParticleTypes;
import mods.railcraft.sounds.RailcraftSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ZapEffectProviderImpl
implements Charge.ZapEffectProvider {
    public static final short TRACKING_DISTANCE = 1024;

    @Override
    public void zapEffectPoint(Level level, double x, double y, double z) {
        RandomSource rand = level.getRandom();
        level.addParticle((ParticleOptions)RailcraftParticleTypes.SPARK.get(), x, y, z, rand.nextDouble() - 0.5, rand.nextDouble() - 0.5, rand.nextDouble() - 0.5);
        level.playLocalSound(x, y, z, (SoundEvent)RailcraftSoundEvents.MACHINE_ZAP.get(), SoundSource.BLOCKS, 0.2f, 0.75f, false);
    }

    @Override
    public void zapEffectSurface(BlockState blockState, Level level, BlockPos pos) {
        RandomSource rand = level.getRandom();
        level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)RailcraftSoundEvents.MACHINE_ZAP.get(), SoundSource.BLOCKS, 0.1f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
        for (Direction side : Direction.values()) {
            if (!Block.shouldRenderFace((BlockState)blockState, (BlockGetter)level, (BlockPos)pos, (Direction)side, (BlockPos)pos.relative(side))) continue;
            Vec3 normal = Vec3.atLowerCornerOf((Vec3i)side.getNormal());
            Vec3 variance = new Vec3((rand.nextGaussian() - 0.5) * 0.2, (rand.nextGaussian() - 0.5) * 0.2, (rand.nextGaussian() - 0.5) * 0.2);
            Vec3 vel = normal.add(variance);
            Vec3 start = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5).add(normal.scale(0.5));
            start = start.add(switch (side.getAxis()) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> new Vec3(0.0, rand.nextDouble() - 0.5, rand.nextDouble() - 0.5);
                case Direction.Axis.Y -> new Vec3(rand.nextDouble() - 0.5, 0.0, rand.nextDouble() - 0.5);
                case Direction.Axis.Z -> new Vec3(rand.nextDouble() - 0.5, rand.nextDouble() - 0.5, 0.0);
            });
            level.addParticle((ParticleOptions)RailcraftParticleTypes.SPARK.get(), start.x(), start.y(), start.z(), vel.x(), vel.y(), vel.z());
        }
    }

    @Override
    public void zapEffectDeath(Level level, double x, double y, double z) {
        level.playSound(null, x, y, z, (SoundEvent)RailcraftSoundEvents.MACHINE_ZAP.get(), SoundSource.BLOCKS, 3.0f, 0.75f);
        for (int i = 0; i < 20; ++i) {
            level.addParticle((ParticleOptions)RailcraftParticleTypes.SPARK.get(), x, y, z, level.getRandom().nextDouble() - 0.5, level.getRandom().nextDouble() - 0.5, level.getRandom().nextDouble() - 0.5);
        }
    }
}

