/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client;

import mods.railcraft.api.signal.TuningAuraHandler;
import mods.railcraft.api.signal.entity.SignalControllerEntity;
import mods.railcraft.client.renderer.blockentity.SignalAuraRenderUtil;
import mods.railcraft.particle.TuningAuraParticleOptions;
import mods.railcraft.world.item.GogglesItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TuningAuraHandlerImpl
implements TuningAuraHandler {
    @Override
    public boolean isTuningAuraActive() {
        return GogglesItem.isGoggleAuraActive(GogglesItem.Aura.TUNING) || GogglesItem.isGoggleAuraActive(GogglesItem.Aura.SIGNALLING);
    }

    @Override
    public void spawnTuningAura(SignalControllerEntity start, BlockEntity dest) {
        Level level = start.asBlockEntity().getLevel();
        RandomSource random = level.getRandom();
        if (random.nextInt(2) != 0) {
            return;
        }
        BlockPos pos = start.asBlockEntity().getBlockPos();
        double px = (double)pos.getX() + TuningAuraHandlerImpl.getRandomParticleOffset(random);
        double py = (double)pos.getY() + TuningAuraHandlerImpl.getRandomParticleOffset(random);
        double pz = (double)pos.getZ() + TuningAuraHandlerImpl.getRandomParticleOffset(random);
        int color = GogglesItem.isGoggleAuraActive(GogglesItem.Aura.SIGNALLING) ? start.getSignalController().aspect().color() : SignalAuraRenderUtil.rainbow(pos, dest.getBlockPos());
        level.addParticle((ParticleOptions)new TuningAuraParticleOptions(dest.getBlockPos().getCenter(), color), px, py, pz, 0.0, 0.0, 0.0);
    }

    private static double getRandomParticleOffset(RandomSource random) {
        return 0.5 + random.nextGaussian() * 0.1;
    }
}

