/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory.widget;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import mods.railcraft.client.gui.screen.inventory.WidgetRenderer;
import mods.railcraft.gui.widget.AnalogGaugeWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class AnalogGaugeRenderer
extends WidgetRenderer<AnalogGaugeWidget> {
    public AnalogGaugeRenderer(AnalogGaugeWidget widget) {
        super(widget);
    }

    @Override
    public List<Component> getTooltip() {
        return ((AnalogGaugeWidget)this.widget).getGauge().getTooltip();
    }

    @Override
    public void render(ResourceLocation widgetLocation, GuiGraphics guiGraphics, int centreX, int centreY, int mouseX, int mouseY) {
        float halfWidth = 1.0f;
        float len = (float)((AnalogGaugeWidget)this.widget).h * 0.75f;
        float value = ((AnalogGaugeWidget)this.widget).getMeasurement();
        float angle = (120.0f * value + 30.0f) * ((float)Math.PI / 180);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float cosA = Mth.cos((float)angle);
        float sinA = Mth.sin((float)angle);
        float glx = cosA * len;
        float gly = sinA * len;
        float gwx = sinA * halfWidth;
        float gwy = cosA * halfWidth;
        float baseOffset = 1.0f / sinA * halfWidth;
        int red = 100;
        int green = 0;
        int blue = 0;
        int alpha = 255;
        float z = 0.0f;
        float gx = centreX + ((AnalogGaugeWidget)this.widget).x;
        float gy = centreY + ((AnalogGaugeWidget)this.widget).y - 1;
        float bx = gx + (float)((AnalogGaugeWidget)this.widget).w * 0.5f;
        float by = gy + (float)((AnalogGaugeWidget)this.widget).h;
        Matrix4f matrix = guiGraphics.pose().last().pose();
        buffer.addVertex(matrix, bx - baseOffset, by, z).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, bx + baseOffset, by, z).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, bx - glx + gwx, by - (gly + gwy), z).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, bx - glx - gwx, by - (gly - gwy), z).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        guiGraphics.blit(widgetLocation, centreX + ((AnalogGaugeWidget)this.widget).ox, centreY + ((AnalogGaugeWidget)this.widget).oy, ((AnalogGaugeWidget)this.widget).ou, ((AnalogGaugeWidget)this.widget).ov, 4, 3);
    }
}

