/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;

public class LowSidesMinecartModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart root;

    public LowSidesMinecartModel(ModelPart root) {
        super(RenderType::entityTranslucentCull);
        this.root = root;
    }

    public static LayerDefinition createBodyLayer(CubeDeformation deformation) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        float length = 20.0f;
        int heightEnds = 8;
        int heightSides = 6;
        float width = 16.0f;
        int yOffset = 4;
        root.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 10).addBox(-length / 2.0f, -width / 2.0f, -1.0f, length, width, 2.0f, deformation), PartPose.offsetAndRotation((float)0.0f, (float)yOffset, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("front", CubeListBuilder.create().texOffs(0, 0).addBox(-width / 2.0f, -length / 2.0f + 1.0f, -1.0f, width, (float)heightEnds, 2.0f, deformation), PartPose.offsetAndRotation((float)-9.0f, (float)yOffset, (float)0.0f, (float)0.0f, (float)4.712389f, (float)0.0f));
        root.addOrReplaceChild("back", CubeListBuilder.create().texOffs(0, 0).addBox(-width / 2.0f, -length / 2.0f + 1.0f, -1.0f, width, (float)heightEnds, 2.0f, deformation), PartPose.offsetAndRotation((float)(length / 2.0f - 1.0f), (float)yOffset, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        root.addOrReplaceChild("left", CubeListBuilder.create().texOffs(0, 0).addBox(-width / 2.0f, (float)(-heightSides - 1), -1.0f, width, (float)heightSides, 2.0f, deformation), PartPose.offsetAndRotation((float)0.0f, (float)yOffset, (float)-7.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        root.addOrReplaceChild("right", CubeListBuilder.create().texOffs(0, 0).addBox(-width / 2.0f, (float)(-heightSides - 1), -1.0f, width, (float)heightSides, 2.0f, deformation), PartPose.offset((float)0.0f, (float)yOffset, (float)7.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public ModelPart root() {
        return this.root;
    }
}

