/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.renderer.entity.cart.CustomMinecartRenderer;
import mods.railcraft.season.Seasons;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.vehicle.AbstractMinecart;

public abstract class StandardMinecartRenderer<T extends AbstractMinecart>
extends CustomMinecartRenderer<T> {
    public static final ResourceLocation SNOW_TEXTURE_LOCATION = RailcraftConstants.rl("textures/carts/cart_snow.png");
    public static final ResourceLocation MINECART_TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/minecart.png");

    public StandardMinecartRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderBody(T cart, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int color) {
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        EntityModel<T> bodyModel = this.getBodyModel(cart);
        VertexConsumer bodyVertexConsumer = bufferSource.getBuffer(bodyModel.renderType(this.getTextureLocation(cart)));
        bodyModel.setupAnim(cart, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        bodyModel.renderToBuffer(poseStack, bodyVertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
        if (Seasons.isPolarExpress(cart)) {
            EntityModel<T> snowModel = this.getSnowModel(cart);
            VertexConsumer snowVertexConsumer = bufferSource.getBuffer(snowModel.renderType(SNOW_TEXTURE_LOCATION));
            snowModel.setupAnim(cart, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
            snowModel.renderToBuffer(poseStack, snowVertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)1, (int)1, (int)1, (int)1));
        }
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(T cart) {
        return MINECART_TEXTURE_LOCATION;
    }

    protected abstract EntityModel<? super T> getBodyModel(T var1);

    protected abstract EntityModel<? super T> getSnowModel(T var1);
}

