/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.data.recipes.builders.RailcraftSpecialRecipeBuilder;
import mods.railcraft.data.recipes.providers.BlastFurnaceRecipeProvider;
import mods.railcraft.data.recipes.providers.CokeOvenRecipeProvider;
import mods.railcraft.data.recipes.providers.CrusherRecipeProvider;
import mods.railcraft.data.recipes.providers.RollingRecipeProvider;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.VariantSet;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.ChestMinecartDisassemblyRecipe;
import mods.railcraft.world.item.crafting.LocomotivePaintingRecipe;
import mods.railcraft.world.item.crafting.PatchouliBookCrafting;
import mods.railcraft.world.item.crafting.RotorRepairRecipe;
import mods.railcraft.world.item.crafting.StoneTieRecipe;
import mods.railcraft.world.item.crafting.TicketDuplicateRecipe;
import mods.railcraft.world.item.crafting.WoodenTieRecipe;
import mods.railcraft.world.item.crafting.WorldSpikeMinecartDisassemblyRecipe;
import mods.railcraft.world.level.block.DecorativeBlock;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class RailcraftRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public RailcraftRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, provider);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        CokeOvenRecipeProvider.genRecipes(recipeOutput);
        BlastFurnaceRecipeProvider.genRecipes(recipeOutput);
        CrusherRecipeProvider.genRecipes(recipeOutput);
        RollingRecipeProvider.genRecipes(recipeOutput);
        this.buildMultiblockBlocks(recipeOutput);
        this.buildBlockStorageRecipes(recipeOutput);
        this.buildIngotsRecipes(recipeOutput);
        this.buildGears(recipeOutput);
        this.buildKits(recipeOutput);
        this.buildTankBlocks(recipeOutput);
        this.buildPost(recipeOutput);
        this.buildStrengthenedGlass(recipeOutput);
        this.buildTie(recipeOutput);
        this.buildCement(recipeOutput);
        this.buildRails(recipeOutput);
        this.buildTracks(recipeOutput);
        this.buildSteelItems(recipeOutput);
        this.buildTunnelBoreHead(recipeOutput);
        this.buildMaul(recipeOutput);
        this.buildOreSmelt(recipeOutput);
        this.buildTurbineParts(recipeOutput);
        this.buildChargeItems(recipeOutput);
        this.buildSignalBox(recipeOutput);
        this.buildSignals(recipeOutput);
        this.buildCircuit(recipeOutput);
        this.buildMiscItems(recipeOutput);
        this.buildCartsVariant(recipeOutput);
        this.buildSwitch(recipeOutput);
        this.buildLoaders(recipeOutput);
        this.buildCrowbars(recipeOutput);
        this.buildFirestones(recipeOutput);
        this.buildDecorativeStone(recipeOutput);
        this.buildBattery(recipeOutput);
        this.buildFrame(recipeOutput);
        this.buildDetectors(recipeOutput);
        RailcraftRecipeProvider.buildWorldSpike(recipeOutput);
    }

    private void conversion(RecipeOutput recipeOutput, ItemLike from, ItemLike to, int count, String optionalName) {
        ResourceLocation path = optionalName.isEmpty() ? RecipeBuilder.getDefaultRecipeId((ItemLike)to) : RailcraftConstants.rl(optionalName);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)to, (int)count).requires(from).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)from), RailcraftRecipeProvider.has((ItemLike)from)).save(recipeOutput, path);
    }

    private void buildRails(RecipeOutput recipeOutput) {
        RailcraftRecipeProvider.railsFromMaterials(recipeOutput, (Item)RailcraftItems.ABANDONED_TRACK.get(), 32, (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_TIE.get());
        RailcraftRecipeProvider.railsFromMaterials(recipeOutput, (Item)RailcraftItems.STRAP_IRON_TRACK.get(), 32, (Item)RailcraftItems.WOODEN_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.railsFromMaterials(recipeOutput, Items.RAIL, 32, (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.railsFromMaterials(recipeOutput, (Item)RailcraftItems.REINFORCED_TRACK.get(), 32, (Item)RailcraftItems.REINFORCED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.railsFromMaterials(recipeOutput, (Item)RailcraftItems.ELECTRIC_TRACK.get(), 32, (Item)RailcraftItems.ELECTRIC_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.railsFromMaterials(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_TRACK.get(), 32, (Item)RailcraftItems.HIGH_SPEED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.railsFromMaterials(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get(), 32, (Item)RailcraftItems.HIGH_SPEED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get(), (Item)RailcraftItems.ELECTRIC_RAIL.get());
        RailcraftRecipeProvider.railsFromMaterials(recipeOutput, (Item)RailcraftItems.ELEVATOR_TRACK.get(), 8, (Item)RailcraftItems.ADVANCED_RAIL.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), Items.REDSTONE);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.WOODEN_RAIL.get()), (int)6).requires((ItemLike)RailcraftItems.WOODEN_TIE.get()).requires(Tags.Items.INGOTS_IRON).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STANDARD_RAIL.get())).requires((ItemLike)Items.RAIL, 8).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.RAIL), RailcraftRecipeProvider.has((ItemLike)Items.RAIL)).save(recipeOutput, RailcraftConstants.rl("standard_rail_from_rail"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.WOODEN_RAILBED.get())).requires((ItemLike)RailcraftItems.WOODEN_TIE.get(), 4).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STONE_RAILBED.get())).requires((ItemLike)RailcraftItems.STONE_TIE.get(), 4).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get()))).save(recipeOutput);
    }

    private static void railsFromMaterials(RecipeOutput recipeOutput, Item result, int count, Item railType, Item railBedType) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)count).pattern("a a").pattern("aba").pattern("a a").define(Character.valueOf('a'), (ItemLike)railType).define(Character.valueOf('b'), (ItemLike)railBedType).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)railType), RailcraftRecipeProvider.has((ItemLike)railType)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)railBedType), RailcraftRecipeProvider.has((ItemLike)railBedType)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)(result.equals(Items.RAIL) ? "minecraft" : "railcraft"), (String)RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath()));
    }

    private static void railsFromMaterials(RecipeOutput recipeOutput, Item result, int count, Item railType, Item railBedType, Item optionalItem) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)count).pattern("aca").pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)railType).define(Character.valueOf('b'), (ItemLike)railBedType).define(Character.valueOf('c'), (ItemLike)optionalItem).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)railType), RailcraftRecipeProvider.has((ItemLike)railType)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)railBedType), RailcraftRecipeProvider.has((ItemLike)railBedType)).save(recipeOutput);
    }

    private void buildTracks(RecipeOutput recipeOutput) {
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_BUFFER_STOP_TRACK.get(), (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_COUPLER_TRACK.get(), (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_CONTROL_TRACK.get(), (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_DISEMBARKING_TRACK.get(), (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_EMBARKING_TRACK.get(), (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_DUMPING_TRACK.get(), (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_GATED_TRACK.get(), (Item)RailcraftItems.GATED_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_LAUNCHER_TRACK.get(), (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_ONE_WAY_TRACK.get(), (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ABANDONED_ROUTING_TRACK.get(), (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_BUFFER_STOP_TRACK.get(), (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_COUPLER_TRACK.get(), (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_CONTROL_TRACK.get(), (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_DISEMBARKING_TRACK.get(), (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_EMBARKING_TRACK.get(), (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_DUMPING_TRACK.get(), (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_GATED_TRACK.get(), (Item)RailcraftItems.GATED_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_LAUNCHER_TRACK.get(), (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_ONE_WAY_TRACK.get(), (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.IRON_ROUTING_TRACK.get(), (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), Items.RAIL);
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_BUFFER_STOP_TRACK.get(), (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_COUPLER_TRACK.get(), (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_CONTROL_TRACK.get(), (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_DISEMBARKING_TRACK.get(), (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_EMBARKING_TRACK.get(), (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_DUMPING_TRACK.get(), (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_GATED_TRACK.get(), (Item)RailcraftItems.GATED_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_LAUNCHER_TRACK.get(), (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_ONE_WAY_TRACK.get(), (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_ROUTING_TRACK.get(), (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_BUFFER_STOP_TRACK.get(), (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_COUPLER_TRACK.get(), (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_CONTROL_TRACK.get(), (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_DISEMBARKING_TRACK.get(), (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_EMBARKING_TRACK.get(), (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_DUMPING_TRACK.get(), (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_GATED_TRACK.get(), (Item)RailcraftItems.GATED_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_LAUNCHER_TRACK.get(), (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_ONE_WAY_TRACK.get(), (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.REINFORCED_ROUTING_TRACK.get(), (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_BUFFER_STOP_TRACK.get(), (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_COUPLER_TRACK.get(), (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_CONTROL_TRACK.get(), (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_DISEMBARKING_TRACK.get(), (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_EMBARKING_TRACK.get(), (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_DUMPING_TRACK.get(), (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_GATED_TRACK.get(), (Item)RailcraftItems.GATED_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_LAUNCHER_TRACK.get(), (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_ONE_WAY_TRACK.get(), (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_ROUTING_TRACK.get(), (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_TRANSITION_TRACK.get(), (Item)RailcraftItems.TRANSITION_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.tracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRANSITION_TRACK.get(), (Item)RailcraftItems.TRANSITION_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        RailcraftRecipeProvider.wyeTracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_WYE_TRACK.get(), (Item)RailcraftItems.WOODEN_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.wyeTracks(recipeOutput, (Item)RailcraftItems.ABANDONED_WYE_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_TIE.get());
        RailcraftRecipeProvider.wyeTracks(recipeOutput, (Item)RailcraftItems.IRON_WYE_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.wyeTracks(recipeOutput, (Item)RailcraftItems.REINFORCED_WYE_TRACK.get(), (Item)RailcraftItems.REINFORCED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.wyeTracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_WYE_TRACK.get(), (Item)RailcraftItems.ELECTRIC_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.wyeTracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_WYE_TRACK.get(), (Item)RailcraftItems.HIGH_SPEED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.turnoutTracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_TURNOUT_TRACK.get(), (Item)RailcraftItems.WOODEN_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.turnoutTracks(recipeOutput, (Item)RailcraftItems.ABANDONED_TURNOUT_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_TIE.get());
        RailcraftRecipeProvider.turnoutTracks(recipeOutput, (Item)RailcraftItems.IRON_TURNOUT_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.turnoutTracks(recipeOutput, (Item)RailcraftItems.REINFORCED_TURNOUT_TRACK.get(), (Item)RailcraftItems.REINFORCED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.turnoutTracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_TURNOUT_TRACK.get(), (Item)RailcraftItems.ELECTRIC_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.turnoutTracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_TURNOUT_TRACK.get(), (Item)RailcraftItems.HIGH_SPEED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.junctionTracks(recipeOutput, (Item)RailcraftItems.STRAP_IRON_JUNCTION_TRACK.get(), (Item)RailcraftItems.WOODEN_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.junctionTracks(recipeOutput, (Item)RailcraftItems.ABANDONED_JUNCTION_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_TIE.get());
        RailcraftRecipeProvider.junctionTracks(recipeOutput, (Item)RailcraftItems.IRON_JUNCTION_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        RailcraftRecipeProvider.junctionTracks(recipeOutput, (Item)RailcraftItems.REINFORCED_JUNCTION_TRACK.get(), (Item)RailcraftItems.REINFORCED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.junctionTracks(recipeOutput, (Item)RailcraftItems.ELECTRIC_JUNCTION_TRACK.get(), (Item)RailcraftItems.ELECTRIC_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        RailcraftRecipeProvider.junctionTracks(recipeOutput, (Item)RailcraftItems.HIGH_SPEED_JUNCTION_TRACK.get(), (Item)RailcraftItems.HIGH_SPEED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_ELECTRIC_WYE_TRACK.get()), (int)16).pattern("aba").pattern("aac").pattern("aba").define(Character.valueOf('a'), (ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get()).define(Character.valueOf('b'), (ItemLike)RailcraftItems.ELECTRIC_RAIL.get()).define(Character.valueOf('c'), (ItemLike)RailcraftItems.STONE_RAILBED.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_ELECTRIC_TURNOUT_TRACK.get()), (int)16).pattern("aca").pattern("aba").pattern("aba").define(Character.valueOf('a'), (ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get()).define(Character.valueOf('b'), (ItemLike)RailcraftItems.ELECTRIC_RAIL.get()).define(Character.valueOf('c'), (ItemLike)RailcraftItems.STONE_RAILBED.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_ELECTRIC_JUNCTION_TRACK.get()), (int)16).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), (ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get()).define(Character.valueOf('b'), (ItemLike)RailcraftItems.ELECTRIC_RAIL.get()).define(Character.valueOf('c'), (ItemLike)RailcraftItems.STONE_RAILBED.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get()))).save(recipeOutput);
    }

    private static void tracks(RecipeOutput recipeOutput, Item result, Item kit, Item baseTrack) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).requires((ItemLike)kit).requires((ItemLike)baseTrack).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)kit), RailcraftRecipeProvider.has((ItemLike)kit)).save(recipeOutput);
    }

    private static void wyeTracks(RecipeOutput recipeOutput, Item result, Item rail, Item railBed) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)16).pattern("aaa").pattern("aab").pattern("aaa").define(Character.valueOf('a'), (ItemLike)rail).define(Character.valueOf('b'), (ItemLike)railBed).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)rail), RailcraftRecipeProvider.has((ItemLike)rail)).save(recipeOutput);
    }

    private static void turnoutTracks(RecipeOutput recipeOutput, Item result, Item rail, Item railBed) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)16).pattern("aba").pattern("aaa").pattern("aaa").define(Character.valueOf('a'), (ItemLike)rail).define(Character.valueOf('b'), (ItemLike)railBed).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)rail), RailcraftRecipeProvider.has((ItemLike)rail)).save(recipeOutput);
    }

    private static void junctionTracks(RecipeOutput recipeOutput, Item result, Item rail, Item railBed) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)16).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)rail).define(Character.valueOf('b'), (ItemLike)railBed).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)rail), RailcraftRecipeProvider.has((ItemLike)rail)).save(recipeOutput);
    }

    private void buildSteelItems(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_ANVIL.get())).pattern("aaa").pattern(" b ").pattern("bbb").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('b'), RailcraftTags.Items.STEEL_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_BLOCK.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_BLOCK)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_SHEARS.get())).pattern(" a").pattern("a ").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_SWORD.get())).pattern("a").pattern("a").pattern("b").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_SHOVEL.get())).pattern("a").pattern("b").pattern("b").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_PICKAXE.get())).pattern("aaa").pattern(" b ").pattern(" b ").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_AXE.get())).pattern("aa").pattern("ab").pattern(" b").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_HOE.get())).pattern("aa").pattern(" b").pattern(" b").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_BOOTS.get())).pattern("a a").pattern("a a").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_LEGGINGS.get())).pattern("aaa").pattern("a a").pattern("a a").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_CHESTPLATE.get())).pattern("a a").pattern("aaa").pattern("aaa").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_HELMET.get())).pattern("aaa").pattern("a a").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_INGOT)).save(recipeOutput);
    }

    private void buildTunnelBoreHead(RecipeOutput recipeOutput) {
        RailcraftRecipeProvider.tunnelBoreHead(recipeOutput, (Item)RailcraftItems.BRONZE_TUNNEL_BORE_HEAD.get(), RailcraftTags.Items.BRONZE_BLOCK);
        RailcraftRecipeProvider.tunnelBoreHead(recipeOutput, (Item)RailcraftItems.IRON_TUNNEL_BORE_HEAD.get(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON);
        RailcraftRecipeProvider.tunnelBoreHead(recipeOutput, (Item)RailcraftItems.STEEL_TUNNEL_BORE_HEAD.get(), RailcraftTags.Items.STEEL_BLOCK);
        RailcraftRecipeProvider.tunnelBoreHead(recipeOutput, (Item)RailcraftItems.DIAMOND_TUNNEL_BORE_HEAD.get(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND);
    }

    private static void tunnelBoreHead(RecipeOutput recipeOutput, Item result, TagKey<Item> center) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), center).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_INGOT)).save(recipeOutput);
    }

    private void buildMaul(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.IRON_SPIKE_MAUL.get())).pattern("aca").pattern(" b ").pattern(" b ").define(Character.valueOf('a'), Tags.Items.INGOTS_IRON).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).define(Character.valueOf('c'), Tags.Items.STORAGE_BLOCKS_IRON).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.IRON_BLOCK), RailcraftRecipeProvider.has((TagKey)Tags.Items.STORAGE_BLOCKS_IRON)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEEL_SPIKE_MAUL.get())).pattern("aca").pattern(" b ").pattern(" b ").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).define(Character.valueOf('c'), RailcraftTags.Items.STEEL_BLOCK).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_BLOCK.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_BLOCK)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.DIAMOND_SPIKE_MAUL.get())).pattern("aca").pattern(" b ").pattern(" b ").define(Character.valueOf('a'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).define(Character.valueOf('c'), Tags.Items.STORAGE_BLOCKS_DIAMOND).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.DIAMOND_BLOCK), RailcraftRecipeProvider.has((TagKey)Tags.Items.STORAGE_BLOCKS_DIAMOND)).save(recipeOutput);
    }

    private void buildOreSmelt(RecipeOutput recipeOutput) {
        List<ItemLike> leadSmeltables = List.of((ItemLike)RailcraftItems.LEAD_ORE.get(), (ItemLike)RailcraftItems.DEEPSLATE_LEAD_ORE.get(), (ItemLike)RailcraftItems.LEAD_RAW.get());
        RailcraftRecipeProvider.oreSmelting((RecipeOutput)recipeOutput, leadSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.LEAD_INGOT.get()), (float)1.0f, (int)200, (String)"lead_ingot");
        RailcraftRecipeProvider.oreBlasting((RecipeOutput)recipeOutput, leadSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.LEAD_INGOT.get()), (float)1.0f, (int)100, (String)"lead_ingot");
        List<ItemLike> nickelSmeltables = List.of((ItemLike)RailcraftItems.NICKEL_ORE.get(), (ItemLike)RailcraftItems.DEEPSLATE_NICKEL_ORE.get(), (ItemLike)RailcraftItems.NICKEL_RAW.get());
        RailcraftRecipeProvider.oreSmelting((RecipeOutput)recipeOutput, nickelSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.NICKEL_INGOT.get()), (float)1.0f, (int)200, (String)"nickel_ingot");
        RailcraftRecipeProvider.oreBlasting((RecipeOutput)recipeOutput, nickelSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.NICKEL_INGOT.get()), (float)1.0f, (int)100, (String)"nickel_ingot");
        List<ItemLike> silverSmeltables = List.of((ItemLike)RailcraftItems.SILVER_ORE.get(), (ItemLike)RailcraftItems.DEEPSLATE_SILVER_ORE.get(), (ItemLike)RailcraftItems.SILVER_RAW.get());
        RailcraftRecipeProvider.oreSmelting((RecipeOutput)recipeOutput, silverSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SILVER_INGOT.get()), (float)1.0f, (int)200, (String)"silver_ingot");
        RailcraftRecipeProvider.oreBlasting((RecipeOutput)recipeOutput, silverSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SILVER_INGOT.get()), (float)1.0f, (int)100, (String)"silver_ingot");
        List<ItemLike> tinSmeltables = List.of((ItemLike)RailcraftItems.TIN_ORE.get(), (ItemLike)RailcraftItems.DEEPSLATE_TIN_ORE.get(), (ItemLike)RailcraftItems.TIN_RAW.get());
        RailcraftRecipeProvider.oreSmelting((RecipeOutput)recipeOutput, tinSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TIN_INGOT.get()), (float)1.0f, (int)200, (String)"tin_ingot");
        RailcraftRecipeProvider.oreBlasting((RecipeOutput)recipeOutput, tinSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TIN_INGOT.get()), (float)1.0f, (int)100, (String)"tin_ingot");
        List<ItemLike> zincSmeltables = List.of((ItemLike)RailcraftItems.ZINC_ORE.get(), (ItemLike)RailcraftItems.DEEPSLATE_ZINC_ORE.get(), (ItemLike)RailcraftItems.ZINC_RAW.get());
        RailcraftRecipeProvider.oreSmelting((RecipeOutput)recipeOutput, zincSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ZINC_INGOT.get()), (float)1.0f, (int)200, (String)"zinc_ingot");
        RailcraftRecipeProvider.oreBlasting((RecipeOutput)recipeOutput, zincSmeltables, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ZINC_INGOT.get()), (float)1.0f, (int)100, (String)"zinc_ingot");
    }

    private void buildTurbineParts(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TURBINE_DISK.get())).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)RailcraftItems.TURBINE_BLADE.get()).define(Character.valueOf('b'), RailcraftTags.Items.STEEL_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.TURBINE_BLADE.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.TURBINE_BLADE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TURBINE_ROTOR.get())).pattern("aaa").define(Character.valueOf('a'), (ItemLike)RailcraftItems.TURBINE_DISK.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.TURBINE_DISK.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.TURBINE_DISK.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEAM_TURBINE.get())).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('b'), RailcraftTags.Items.STEEL_PLATE).define(Character.valueOf('c'), (ItemLike)RailcraftItems.CHARGE_MOTOR.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.CHARGE_MOTOR.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.CHARGE_MOTOR.get()))).save(recipeOutput);
        RailcraftSpecialRecipeBuilder.special(RotorRepairRecipe::new).save(recipeOutput, "rotor_repair");
    }

    private void buildSignalBox(RecipeOutput recipeOutput) {
        RailcraftRecipeProvider.signalBox(recipeOutput, (Item)RailcraftItems.SIGNAL_CONTROLLER_BOX.get(), (Item)RailcraftItems.CONTROLLER_CIRCUIT.get(), Items.REDSTONE);
        RailcraftRecipeProvider.signalBox(recipeOutput, (Item)RailcraftItems.SIGNAL_RECEIVER_BOX.get(), (Item)RailcraftItems.RECEIVER_CIRCUIT.get(), Items.REDSTONE);
        RailcraftRecipeProvider.signalBox(recipeOutput, (Item)RailcraftItems.ANALOG_SIGNAL_CONTROLLER_BOX.get(), (Item)RailcraftItems.CONTROLLER_CIRCUIT.get(), Items.COMPARATOR);
        RailcraftRecipeProvider.signalBox(recipeOutput, (Item)RailcraftItems.SIGNAL_CAPACITOR_BOX.get(), Items.REPEATER, Items.REDSTONE);
        RailcraftRecipeProvider.signalBox(recipeOutput, (Item)RailcraftItems.SIGNAL_SEQUENCER_BOX.get(), Items.COMPARATOR, Items.REDSTONE);
        Item circuit = (Item)RailcraftItems.CONTROLLER_CIRCUIT.get();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SIGNAL_INTERLOCK_BOX.get())).pattern(" d ").pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('b'), (ItemLike)circuit).define(Character.valueOf('c'), (ItemLike)Items.REDSTONE).define(Character.valueOf('d'), (ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)circuit), RailcraftRecipeProvider.has((ItemLike)circuit)).save(recipeOutput);
        circuit = (Item)RailcraftItems.SIGNAL_CIRCUIT.get();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SIGNAL_BLOCK_RELAY_BOX.get())).pattern(" c ").pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('b'), (ItemLike)circuit).define(Character.valueOf('c'), (ItemLike)Items.REDSTONE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)circuit), RailcraftRecipeProvider.has((ItemLike)circuit)).save(recipeOutput);
        circuit = (Item)RailcraftItems.RADIO_CIRCUIT.get();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TOKEN_SIGNAL_BOX.get())).pattern(" c ").pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('b'), (ItemLike)circuit).define(Character.valueOf('c'), (ItemLike)Items.REDSTONE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)circuit), RailcraftRecipeProvider.has((ItemLike)circuit)).save(recipeOutput);
    }

    private static void signalBox(RecipeOutput recipeOutput, Item result, Item circuit, Item bottomItem) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('b'), (ItemLike)circuit).define(Character.valueOf('c'), (ItemLike)bottomItem).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)circuit), RailcraftRecipeProvider.has((ItemLike)circuit)).save(recipeOutput);
    }

    private void buildSignals(RecipeOutput recipeOutput) {
        RailcraftRecipeProvider.singleSignal(recipeOutput, (Item)RailcraftItems.BLOCK_SIGNAL.get(), (Item)RailcraftItems.SIGNAL_CIRCUIT.get());
        RailcraftRecipeProvider.singleSignal(recipeOutput, (Item)RailcraftItems.DISTANT_SIGNAL.get(), (Item)RailcraftItems.RECEIVER_CIRCUIT.get());
        RailcraftRecipeProvider.singleSignal(recipeOutput, (Item)RailcraftItems.TOKEN_SIGNAL.get(), (Item)RailcraftItems.RADIO_CIRCUIT.get());
        RailcraftRecipeProvider.dualSignal(recipeOutput, (Item)RailcraftItems.DUAL_BLOCK_SIGNAL.get(), (Item)RailcraftItems.SIGNAL_CIRCUIT.get());
        RailcraftRecipeProvider.dualSignal(recipeOutput, (Item)RailcraftItems.DUAL_DISTANT_SIGNAL.get(), (Item)RailcraftItems.RECEIVER_CIRCUIT.get());
        RailcraftRecipeProvider.dualSignal(recipeOutput, (Item)RailcraftItems.DUAL_TOKEN_SIGNAL.get(), (Item)RailcraftItems.RADIO_CIRCUIT.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SIGNAL_LAMP.get())).pattern("ab ").pattern("ace").pattern("adf").define(Character.valueOf('a'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('b'), Tags.Items.DYES_LIME).define(Character.valueOf('c'), Tags.Items.DYES_YELLOW).define(Character.valueOf('d'), Tags.Items.DYES_RED).define(Character.valueOf('e'), (ItemLike)Items.GLOWSTONE_DUST).define(Character.valueOf('f'), (ItemLike)Items.REDSTONE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.GLOWSTONE_DUST), RailcraftRecipeProvider.has((ItemLike)Items.GLOWSTONE_DUST)).save(recipeOutput);
    }

    private static void singleSignal(RecipeOutput recipeOutput, Item result, Item circuit) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("abc").pattern(" dc").define(Character.valueOf('a'), (ItemLike)RailcraftItems.SIGNAL_LAMP.get()).define(Character.valueOf('b'), (ItemLike)circuit).define(Character.valueOf('c'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('d'), Tags.Items.DYES_BLACK).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)circuit), RailcraftRecipeProvider.has((ItemLike)circuit)).save(recipeOutput);
    }

    private static void dualSignal(RecipeOutput recipeOutput, Item result, Item circuit) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("abc").pattern(" dc").pattern("aec").define(Character.valueOf('a'), (ItemLike)RailcraftItems.SIGNAL_LAMP.get()).define(Character.valueOf('b'), (ItemLike)circuit).define(Character.valueOf('c'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('d'), Tags.Items.DYES_BLACK).define(Character.valueOf('e'), (ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)circuit), RailcraftRecipeProvider.has((ItemLike)circuit)).save(recipeOutput);
    }

    private void buildCircuit(RecipeOutput recipeOutput) {
        RailcraftRecipeProvider.circuitFromMaterial(recipeOutput, (Item)RailcraftItems.CONTROLLER_CIRCUIT.get(), Items.RED_WOOL);
        RailcraftRecipeProvider.circuitFromMaterial(recipeOutput, (Item)RailcraftItems.RECEIVER_CIRCUIT.get(), Items.GREEN_WOOL);
        RailcraftRecipeProvider.circuitFromMaterial(recipeOutput, (Item)RailcraftItems.SIGNAL_CIRCUIT.get(), Items.YELLOW_WOOL);
        RailcraftRecipeProvider.circuitFromMaterial(recipeOutput, (Item)RailcraftItems.RADIO_CIRCUIT.get(), Items.BLUE_WOOL);
    }

    private static void circuitFromMaterial(RecipeOutput recipeOutput, Item itemOut, Item woolItem) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)itemOut).define(Character.valueOf('W'), (ItemLike)woolItem).define(Character.valueOf('R'), (ItemLike)Items.REPEATER).define(Character.valueOf('S'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('L'), Tags.Items.GEMS_LAPIS).define(Character.valueOf('B'), Tags.Items.SLIMEBALLS).pattern(" RW").pattern("BGS").pattern("WSL").unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.REDSTONE), RailcraftRecipeProvider.has((TagKey)Tags.Items.DUSTS_REDSTONE)).save(recipeOutput);
    }

    private void buildSwitch(RecipeOutput recipeOutput) {
        RailcraftRecipeProvider.switchItem(recipeOutput, (Item)RailcraftItems.SWITCH_TRACK_LEVER.get(), Items.LEVER);
        RailcraftRecipeProvider.switchItem(recipeOutput, (Item)RailcraftItems.SWITCH_TRACK_MOTOR.get(), (Item)RailcraftItems.RECEIVER_CIRCUIT.get());
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SWITCH_TRACK_ROUTER.get())).requires((ItemLike)RailcraftItems.SWITCH_TRACK_MOTOR.get()).requires((ItemLike)RailcraftItems.ROUTING_DETECTOR.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.SWITCH_TRACK_MOTOR.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.SWITCH_TRACK_MOTOR.get()))).save(recipeOutput);
    }

    private static void switchItem(RecipeOutput recipeOutput, Item result, Item circuit) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("abc").pattern("def").define(Character.valueOf('a'), Tags.Items.DYES_RED).define(Character.valueOf('b'), Tags.Items.DYES_BLACK).define(Character.valueOf('c'), (ItemLike)Items.BONE_MEAL).define(Character.valueOf('d'), (ItemLike)Items.PISTON).define(Character.valueOf('e'), (ItemLike)circuit).define(Character.valueOf('f'), (ItemLike)Items.IRON_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)circuit), RailcraftRecipeProvider.has((ItemLike)circuit)).save(recipeOutput);
    }

    private void buildLoaders(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ITEM_LOADER.get())).pattern("aaa").pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.COBBLESTONE).define(Character.valueOf('b'), (ItemLike)Items.HOPPER).define(Character.valueOf('c'), (ItemLike)RailcraftItems.ITEM_DETECTOR.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.ITEM_DETECTOR.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.ITEM_DETECTOR.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ADVANCED_ITEM_LOADER.get())).pattern("aba").pattern("bcb").pattern("ada").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE).define(Character.valueOf('c'), (ItemLike)RailcraftItems.ITEM_LOADER.get()).define(Character.valueOf('d'), (ItemLike)RailcraftItems.STEEL_SHOVEL.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.ITEM_LOADER.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.ITEM_LOADER.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ITEM_UNLOADER.get())).pattern("aaa").pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.COBBLESTONE).define(Character.valueOf('b'), (ItemLike)RailcraftItems.ITEM_DETECTOR.get()).define(Character.valueOf('c'), (ItemLike)Items.HOPPER).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.ITEM_DETECTOR.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.ITEM_DETECTOR.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ADVANCED_ITEM_UNLOADER.get())).pattern("aba").pattern("bcb").pattern("ada").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE).define(Character.valueOf('c'), (ItemLike)RailcraftItems.ITEM_UNLOADER.get()).define(Character.valueOf('d'), (ItemLike)RailcraftItems.STEEL_SHOVEL.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.ITEM_UNLOADER.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.ITEM_UNLOADER.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.FLUID_LOADER.get())).pattern("aba").pattern("a a").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.GLASS).define(Character.valueOf('b'), (ItemLike)Items.HOPPER).define(Character.valueOf('c'), (ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.FLUID_UNLOADER.get())).pattern("aba").pattern("a a").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.GLASS).define(Character.valueOf('b'), (ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get()).define(Character.valueOf('c'), (ItemLike)Items.HOPPER).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CART_DISPENSER.get())).requires((ItemLike)Items.DISPENSER).requires((ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.DISPENSER), RailcraftRecipeProvider.has((ItemLike)Items.DISPENSER)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), RailcraftRecipeProvider.has((ItemLike)Items.MINECART)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TRAIN_DISPENSER.get())).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), (ItemLike)Items.REDSTONE).define(Character.valueOf('b'), RailcraftTags.Items.CROWBAR).define(Character.valueOf('c'), (ItemLike)RailcraftItems.CART_DISPENSER.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.CART_DISPENSER.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.CART_DISPENSER.get()))).save(recipeOutput);
    }

    private void buildCrowbars(RecipeOutput recipeOutput) {
        RailcraftRecipeProvider.crowbar(recipeOutput, (Item)RailcraftItems.IRON_CROWBAR.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        RailcraftRecipeProvider.crowbar(recipeOutput, (Item)RailcraftItems.STEEL_CROWBAR.get(), RailcraftTags.Items.STEEL_INGOT);
        RailcraftRecipeProvider.crowbar(recipeOutput, (Item)RailcraftItems.DIAMOND_CROWBAR.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
    }

    private static void crowbar(RecipeOutput recipeOutput, Item itemOut, TagKey<Item> materialTag) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)itemOut).pattern(" ba").pattern("bab").pattern("ab ").define(Character.valueOf('a'), materialTag).define(Character.valueOf('b'), Tags.Items.DYES_RED).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.RAIL), RailcraftRecipeProvider.has((ItemLike)Items.RAIL)).save(recipeOutput);
    }

    private void buildFirestones(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.REFINED_FIRESTONE.get())).pattern("LRL").pattern("RSR").pattern("LRL").define(Character.valueOf('L'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_BLOCK).define(Character.valueOf('S'), (ItemLike)RailcraftItems.CUT_FIRESTONE.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.CUT_FIRESTONE.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.CUT_FIRESTONE.get()))).save(recipeOutput, RailcraftConstants.rl("firestone_lava_refinement"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.REFINED_FIRESTONE.get())).pattern("LFL").pattern("RSR").pattern("LRL").define(Character.valueOf('L'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_BLOCK).define(Character.valueOf('S'), (ItemLike)RailcraftItems.CRACKED_FIRESTONE.get()).define(Character.valueOf('F'), (ItemLike)RailcraftItems.RAW_FIRESTONE.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.CRACKED_FIRESTONE.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.CRACKED_FIRESTONE.get()))).save(recipeOutput, RailcraftConstants.rl("firestone_cracked_fixing"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CUT_FIRESTONE.get())).pattern(" a ").pattern("aba").pattern(" a ").define(Character.valueOf('a'), (ItemLike)Items.NETHERITE_PICKAXE).define(Character.valueOf('b'), (ItemLike)RailcraftItems.RAW_FIRESTONE.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.RAW_FIRESTONE.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.RAW_FIRESTONE.get()))).save(recipeOutput);
    }

    private void buildMiscItems(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.FEED_STATION.get())).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), ItemTags.PLANKS).define(Character.valueOf('b'), (ItemLike)Items.GOLDEN_CARROT).define(Character.valueOf('c'), RailcraftTags.Items.STEEL_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_PLATE.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_PLATE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CHIMNEY.get())).pattern(" a ").pattern("bcb").define(Character.valueOf('a'), (ItemLike)Items.NETHERRACK).define(Character.valueOf('b'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('c'), (ItemLike)Items.CAULDRON).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.REDSTONE), RailcraftRecipeProvider.has((ItemLike)Items.REDSTONE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.LOGBOOK.get())).pattern(" a ").pattern("bcb").pattern("ddd").define(Character.valueOf('a'), (ItemLike)Items.WRITABLE_BOOK).define(Character.valueOf('b'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('c'), (ItemLike)Items.RED_WOOL).define(Character.valueOf('d'), ItemTags.PLANKS).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.WRITABLE_BOOK), RailcraftRecipeProvider.has((ItemLike)Items.WRITABLE_BOOK)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.MANUAL_ROLLING_MACHINE.get())).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), RailcraftTags.Items.BRONZE_GEAR).define(Character.valueOf('b'), (ItemLike)Items.PISTON).define(Character.valueOf('c'), (ItemLike)Items.CRAFTING_TABLE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.PISTON), RailcraftRecipeProvider.has((ItemLike)Items.PISTON)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.POWERED_ROLLING_MACHINE.get())).pattern("aba").pattern("bcb").pattern("ada").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_GEAR).define(Character.valueOf('b'), (ItemLike)Items.PISTON).define(Character.valueOf('c'), (ItemLike)Items.CRAFTING_TABLE).define(Character.valueOf('d'), (ItemLike)RailcraftItems.CHARGE_MOTOR.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.MANUAL_ROLLING_MACHINE.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.MANUAL_ROLLING_MACHINE.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.GOLDEN_TICKET.get())).requires((ItemLike)Items.PAPER).requires(Tags.Items.NUGGETS_GOLD).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.PAPER), RailcraftRecipeProvider.has((ItemLike)Items.PAPER)).save(recipeOutput);
        RailcraftSpecialRecipeBuilder.special(TicketDuplicateRecipe::new).save(recipeOutput, RailcraftRecipeProvider.getItemName((ItemLike)((ItemLike)RailcraftItems.TICKET.get())));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ROUTING_TABLE_BOOK.get())).requires((ItemLike)Items.WRITABLE_BOOK).requires(Tags.Items.DYES_BLUE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.WRITABLE_BOOK), RailcraftRecipeProvider.has((ItemLike)Items.WRITABLE_BOOK)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.OVERALLS.get())).pattern("aaa").pattern("a a").pattern("a a").define(Character.valueOf('a'), (ItemLike)Items.CYAN_WOOL).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.CYAN_WOOL), RailcraftRecipeProvider.has((ItemLike)Items.CYAN_WOOL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.WHISTLE_TUNER.get())).pattern("a a").pattern("aaa").pattern(" a ").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_NUGGET).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_NUGGET.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_NUGGET)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SIGNAL_LABEL.get())).requires((ItemLike)Items.PAPER).requires(RailcraftTags.Items.STEEL_NUGGET).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_NUGGET.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.STEEL_NUGGET.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.FORCE_TRACK_EMITTER.get())).pattern("aba").pattern("cdc").pattern("aba").define(Character.valueOf('a'), RailcraftTags.Items.TIN_PLATE).define(Character.valueOf('b'), RailcraftTags.Items.ENDER_DUST).define(Character.valueOf('c'), (ItemLike)RailcraftItems.CHARGE_COIL.get()).define(Character.valueOf('d'), Tags.Items.STORAGE_BLOCKS_DIAMOND).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.ENDER_DUST.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.ENDER_DUST.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SIGNAL_BLOCK_SURVEYOR.get())).pattern(" a ").pattern("cbc").pattern(" d ").define(Character.valueOf('a'), (ItemLike)Items.COMPASS).define(Character.valueOf('b'), Tags.Items.GLASS_PANES).define(Character.valueOf('c'), (ItemLike)Blocks.STONE_BUTTON).define(Character.valueOf('d'), Tags.Items.DUSTS_REDSTONE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.REDSTONE), RailcraftRecipeProvider.has((TagKey)Tags.Items.DUSTS_REDSTONE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SIGNAL_TUNER.get())).define(Character.valueOf('a'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('b'), (ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()).define(Character.valueOf('c'), (ItemLike)Blocks.STONE_BUTTON).pattern(" a ").pattern("cbc").unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.REDSTONE), RailcraftRecipeProvider.has((TagKey)Tags.Items.DUSTS_REDSTONE)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.GOGGLES.get())).pattern("aba").pattern("c c").pattern("ddd").define(Character.valueOf('a'), Tags.Items.GLASS_PANES).define(Character.valueOf('b'), (ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()).define(Character.valueOf('c'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('d'), Tags.Items.LEATHERS).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.STEEL_INGOT)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.WATER_TANK_SIDING.get()), (int)6).pattern("aaa").pattern("bcb").pattern("aaa").define(Character.valueOf('a'), ItemTags.PLANKS).define(Character.valueOf('b'), Tags.Items.INGOTS_IRON).define(Character.valueOf('c'), (ItemLike)Items.SLIME_BALL).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.IRON_INGOT), RailcraftRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.SLIME_BALL), RailcraftRecipeProvider.has((ItemLike)Items.SLIME_BALL)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GUNPOWDER, (int)2).requires(RailcraftTags.Items.SALTPETER_DUST).requires(RailcraftTags.Items.SALTPETER_DUST).requires(RailcraftTags.Items.SULFUR_DUST).requires(RailcraftTags.Items.CHARCOAL_DUST).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.SALTPETER_DUST.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.SALTPETER_DUST)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.SULFUR_DUST.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.SULFUR_DUST)).save(recipeOutput);
        RailcraftSpecialRecipeBuilder.special(PatchouliBookCrafting::new).save(recipeOutput.withConditions(new ICondition[]{this.modLoaded("patchouli")}), "patchouli_book_crafting");
    }

    private void buildCartsVariant(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TANK_MINECART.get())).pattern("a").pattern("b").define(Character.valueOf('a'), RailcraftTags.Items.STRENGTHENED_GLASS).define(Character.valueOf('b'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STRENGTHENED_GLASS.variantFor(DyeColor.WHITE).get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.STRENGTHENED_GLASS.variantFor(DyeColor.WHITE).get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, RailcraftItems.ENERGY_MINECART).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), RailcraftTags.Items.LEAD_INGOT).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE_BLOCK).define(Character.valueOf('c'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.LEAD_INGOT.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.LEAD_INGOT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, RailcraftItems.WORLD_SPIKE_MINECART).pattern("a").pattern("b").define(Character.valueOf('a'), RailcraftItems.WORLD_SPIKE).define(Character.valueOf('b'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName(RailcraftItems.WORLD_SPIKE), RailcraftRecipeProvider.has(RailcraftItems.WORLD_SPIKE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TUNNEL_BORE.get())).pattern("aba").pattern("cbc").pattern(" d ").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('b'), (ItemLike)Items.MINECART).define(Character.valueOf('c'), (ItemLike)Items.FURNACE).define(Character.valueOf('d'), (ItemLike)Items.CHEST_MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), RailcraftRecipeProvider.has((ItemLike)Items.MINECART)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEAM_LOCOMOTIVE.get())).pattern("aab").pattern("aab").pattern("cdd").define(Character.valueOf('a'), RailcraftTags.Items.IRON_TANK_WALL).define(Character.valueOf('b'), (ItemLike)RailcraftItems.BLAST_FURNACE_BRICKS.get()).define(Character.valueOf('c'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('d'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), RailcraftRecipeProvider.has((ItemLike)Items.MINECART)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ELECTRIC_LOCOMOTIVE.get())).pattern("ab ").pattern("cdc").pattern("efe").define(Character.valueOf('a'), (ItemLike)Items.REDSTONE_LAMP).define(Character.valueOf('b'), RailcraftTags.Items.STEEL_PLATE).define(Character.valueOf('c'), (ItemLike)RailcraftItems.CHARGE_MOTOR.get()).define(Character.valueOf('d'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.NICKEL_IRON_BATTERY.get(), (ItemLike)RailcraftItems.NICKEL_ZINC_BATTERY.get()})).define(Character.valueOf('e'), RailcraftTags.Items.STEEL_GEAR).define(Character.valueOf('f'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), RailcraftRecipeProvider.has((ItemLike)Items.MINECART)).save(recipeOutput);
        RailcraftSpecialRecipeBuilder.special(LocomotivePaintingRecipe::new).save(recipeOutput, "locomotive_color_variant");
        RailcraftSpecialRecipeBuilder.special(ChestMinecartDisassemblyRecipe::new).save(recipeOutput, "chest_minecart_disassembly");
        RailcraftSpecialRecipeBuilder.special(WorldSpikeMinecartDisassemblyRecipe::new).save(recipeOutput, "worldspike_minecart_disassembly");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TRACK_LAYER.get())).pattern("aba").pattern("cdc").pattern("efe").define(Character.valueOf('a'), Tags.Items.DYES_YELLOW).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE_LAMP).define(Character.valueOf('c'), (ItemLike)Items.ANVIL).define(Character.valueOf('d'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('e'), (ItemLike)Items.DISPENSER).define(Character.valueOf('f'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), RailcraftRecipeProvider.has((ItemLike)Items.MINECART)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TRACK_RELAYER.get())).pattern("aba").pattern("cdc").pattern("efe").define(Character.valueOf('a'), Tags.Items.DYES_YELLOW).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE_LAMP).define(Character.valueOf('c'), (ItemLike)Items.BLAZE_ROD).define(Character.valueOf('d'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('e'), (ItemLike)Items.DIAMOND_PICKAXE).define(Character.valueOf('f'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), RailcraftRecipeProvider.has((ItemLike)Items.MINECART)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TRACK_REMOVER.get())).pattern("aba").pattern("cdc").pattern("efe").define(Character.valueOf('a'), Tags.Items.DYES_YELLOW).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE_LAMP).define(Character.valueOf('c'), (ItemLike)Items.STICKY_PISTON).define(Character.valueOf('d'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('e'), RailcraftTags.Items.CROWBAR).define(Character.valueOf('f'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), RailcraftRecipeProvider.has((ItemLike)Items.MINECART)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TRACK_UNDERCUTTER.get())).pattern("aba").pattern("cdc").pattern("efe").define(Character.valueOf('a'), Tags.Items.DYES_YELLOW).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE_LAMP).define(Character.valueOf('c'), (ItemLike)Items.PISTON).define(Character.valueOf('d'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('e'), (ItemLike)Items.DIAMOND_SHOVEL).define(Character.valueOf('f'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), RailcraftRecipeProvider.has((ItemLike)Items.MINECART)).save(recipeOutput);
    }

    private void buildChargeItems(RecipeOutput recipeOutput) {
        this.conversion(recipeOutput, (ItemLike)RailcraftItems.CHARGE_SPOOL_MEDIUM.get(), (ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get(), 3, "charge_spool_small_from_medium");
        this.conversion(recipeOutput, (ItemLike)RailcraftItems.CHARGE_SPOOL_LARGE.get(), (ItemLike)RailcraftItems.CHARGE_SPOOL_MEDIUM.get(), 3, "charge_spool_medium_from_large");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CHARGE_TERMINAL.get())).pattern(" b ").pattern("aaa").define(Character.valueOf('a'), RailcraftTags.Items.BRASS_INGOT).define(Character.valueOf('b'), RailcraftTags.Items.BRASS_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.BRASS_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.BRASS_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CHARGE_COIL.get())).pattern("aaa").pattern("bbb").pattern("aaa").define(Character.valueOf('a'), (ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get()).define(Character.valueOf('b'), RailcraftTags.Items.IRON_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CHARGE_MOTOR.get())).pattern(" a ").pattern("bcb").pattern(" d ").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), RailcraftTags.Items.TIN_PLATE).define(Character.valueOf('c'), (ItemLike)RailcraftItems.CHARGE_COIL.get()).define(Character.valueOf('d'), (ItemLike)RailcraftItems.CHARGE_TERMINAL.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CHARGE_METER.get())).pattern("a a").pattern("bcb").pattern(" d ").define(Character.valueOf('a'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('b'), (ItemLike)Items.STONE_BUTTON).define(Character.valueOf('c'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('d'), RailcraftTags.Items.BRASS_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.BRASS_INGOT.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.BRASS_INGOT.get()))).save(recipeOutput);
    }

    private void buildKits(RecipeOutput recipeOutput) {
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)2)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), 16, List.of(new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.ADVANCED_RAIL.get()}), (Object)2), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), 2, List.of(new Tuple((Object)Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), (Object)2)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), 16, List.of(new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.ADVANCED_RAIL.get()}), (Object)1), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE_PRESSURE_PLATE}), (Object)1), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE_PRESSURE_PLATE}), (Object)1), new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.LEAD}), (Object)1), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_PEARL}), (Object)1), new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.LEAD}), (Object)1), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of(RailcraftTags.Items.STEEL_PLATE), (Object)1), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.GATED_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of((TagKey)Tags.Items.FENCE_GATES), (Object)1), new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.ADVANCED_RAIL.get()}), (Object)1), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE_PRESSURE_PLATE}), (Object)1), new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.STICKY_PISTON}), (Object)1), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE_PRESSURE_PLATE}), (Object)1), new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.PISTON}), (Object)1), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), 1, List.of(new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.PISTON}), (Object)1), new Tuple((Object)Ingredient.of(RailcraftTags.Items.STEEL_BLOCK), (Object)2), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.SIGNAL_LAMP.get()}), (Object)1), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.TRANSITION_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.ADVANCED_RAIL.get()}), (Object)2), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)2)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.LEAD}), (Object)1), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.TICKET.get(), (ItemLike)RailcraftItems.GOLDEN_TICKET.get()}), (Object)1), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DYES_YELLOW), (Object)1), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DYES_BLACK), (Object)1), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
        RailcraftRecipeProvider.kits(recipeOutput, (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DYES_YELLOW), (Object)1), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DYES_BLACK), (Object)1), new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.NOTE_BLOCK}), (Object)1), new Tuple((Object)Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), (Object)1)));
    }

    private static void kits(RecipeOutput recipeOutput, Item result, int count, List<Tuple<Ingredient, Integer>> ingredients) {
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)count).requires(ItemTags.PLANKS).requires((ItemLike)RailcraftItems.TRACK_PARTS.get());
        for (Tuple<Ingredient, Integer> ingredient : ingredients) {
            builder = builder.requires((Ingredient)ingredient.getA(), ((Integer)ingredient.getB()).intValue());
        }
        builder.unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.TRACK_PARTS.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.TRACK_PARTS.get()))).save(recipeOutput);
    }

    private void buildGears(RecipeOutput recipeOutput) {
        RailcraftRecipeProvider.square2x2(recipeOutput, RailcraftTags.Items.BRONZE_INGOT, (Item)RailcraftItems.BUSHING_GEAR.get(), 1, "_bronze");
        RailcraftRecipeProvider.square2x2(recipeOutput, RailcraftTags.Items.BRASS_INGOT, (Item)RailcraftItems.BUSHING_GEAR.get(), 1, "_brass");
        RailcraftRecipeProvider.gear(recipeOutput, (Item)RailcraftItems.IRON_GEAR.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        RailcraftRecipeProvider.gear(recipeOutput, (Item)RailcraftItems.COPPER_GEAR.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        RailcraftRecipeProvider.gear(recipeOutput, (Item)RailcraftItems.GOLD_GEAR.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        RailcraftRecipeProvider.gear(recipeOutput, (Item)RailcraftItems.STEEL_GEAR.get(), RailcraftTags.Items.STEEL_INGOT);
        RailcraftRecipeProvider.gear(recipeOutput, (Item)RailcraftItems.TIN_GEAR.get(), RailcraftTags.Items.TIN_INGOT);
        RailcraftRecipeProvider.gear(recipeOutput, (Item)RailcraftItems.ZINC_GEAR.get(), RailcraftTags.Items.ZINC_INGOT);
        RailcraftRecipeProvider.gear(recipeOutput, (Item)RailcraftItems.BRASS_GEAR.get(), RailcraftTags.Items.BRASS_INGOT);
        RailcraftRecipeProvider.gear(recipeOutput, (Item)RailcraftItems.BRONZE_GEAR.get(), RailcraftTags.Items.BRONZE_INGOT);
        RailcraftRecipeProvider.gear(recipeOutput, (Item)RailcraftItems.NICKEL_GEAR.get(), RailcraftTags.Items.NICKEL_INGOT);
        RailcraftRecipeProvider.gear(recipeOutput, (Item)RailcraftItems.INVAR_GEAR.get(), RailcraftTags.Items.INVAR_INGOT);
        RailcraftRecipeProvider.gear(recipeOutput, (Item)RailcraftItems.SILVER_GEAR.get(), RailcraftTags.Items.SILVER_INGOT);
        RailcraftRecipeProvider.gear(recipeOutput, (Item)RailcraftItems.LEAD_GEAR.get(), RailcraftTags.Items.LEAD_INGOT);
    }

    private static void gear(RecipeOutput recipeOutput, Item itemOut, TagKey<Item> materialTag) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)itemOut).pattern(" a ").pattern("aba").pattern(" a ").define(Character.valueOf('a'), materialTag).define(Character.valueOf('b'), (ItemLike)RailcraftItems.BUSHING_GEAR.get()).unlockedBy("has_material", RailcraftRecipeProvider.has(materialTag)).save(recipeOutput);
    }

    private void buildMultiblockBlocks(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.FLUID_FUELED_FIREBOX.get())).pattern("aca").pattern("bdb").pattern("aea").define(Character.valueOf('a'), RailcraftTags.Items.INVAR_PLATE).define(Character.valueOf('b'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('c'), (ItemLike)Items.BUCKET).define(Character.valueOf('d'), (ItemLike)Items.FIRE_CHARGE).define(Character.valueOf('e'), (ItemLike)Items.FURNACE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.INVAR_PLATE.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.INVAR_PLATE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SOLID_FUELED_FIREBOX.get())).pattern("aaa").pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.NETHER_BRICK).define(Character.valueOf('b'), (ItemLike)Items.FIRE_CHARGE).define(Character.valueOf('c'), (ItemLike)Items.FURNACE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.FIRE_CHARGE), RailcraftRecipeProvider.has((ItemLike)Items.FIRE_CHARGE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.COKE_OVEN_BRICKS.get()), (int)2).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), (ItemLike)Items.SAND).define(Character.valueOf('b'), (ItemLike)Items.BRICK).define(Character.valueOf('c'), (ItemLike)Items.CLAY).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.BRICK), RailcraftRecipeProvider.has((ItemLike)Items.BRICK)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.BLAST_FURNACE_BRICKS.get()), (int)4).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), (ItemLike)Items.SOUL_SAND).define(Character.valueOf('b'), (ItemLike)Items.NETHER_BRICK).define(Character.valueOf('c'), (ItemLike)Items.MAGMA_CREAM).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MAGMA_CREAM), RailcraftRecipeProvider.has((ItemLike)Items.MAGMA_CREAM)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CRUSHER.get()), (int)4).pattern("aba").pattern("bcb").pattern("ada").define(Character.valueOf('a'), (ItemLike)Items.DIAMOND).define(Character.valueOf('b'), (ItemLike)Items.PISTON).define(Character.valueOf('c'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('d'), (ItemLike)RailcraftItems.CHARGE_MOTOR.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.CHARGE_MOTOR.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.CHARGE_MOTOR.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.HIGH_PRESSURE_STEAM_BOILER_TANK.get()), (int)2).pattern("a").pattern("b").pattern("a").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_PLATE).define(Character.valueOf('b'), RailcraftTags.Items.INVAR_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_PLATE.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.STEEL_PLATE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.LOW_PRESSURE_STEAM_BOILER_TANK.get()), (int)2).pattern("a").pattern("b").pattern("a").define(Character.valueOf('a'), RailcraftTags.Items.IRON_PLATE).define(Character.valueOf('b'), RailcraftTags.Items.INVAR_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.IRON_PLATE.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.IRON_PLATE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.STEAM_OVEN.get()), (int)4).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_PLATE).define(Character.valueOf('b'), (ItemLike)Items.FURNACE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_PLATE.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.STEEL_PLATE.get()))).save(recipeOutput);
    }

    private void buildBlockStorageRecipes(RecipeOutput recipeOutput) {
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.STEEL_NUGGET.get(), (ItemLike)RailcraftItems.STEEL_INGOT.get(), "steel_ingot_from_steel_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.TIN_NUGGET.get(), (ItemLike)RailcraftItems.TIN_INGOT.get(), "tin_ingot_from_tin_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.ZINC_NUGGET.get(), (ItemLike)RailcraftItems.ZINC_INGOT.get(), "zinc_ingot_from_zinc_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.BRASS_NUGGET.get(), (ItemLike)RailcraftItems.BRASS_INGOT.get(), "brass_ingot_from_brass_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.BRONZE_NUGGET.get(), (ItemLike)RailcraftItems.BRONZE_INGOT.get(), "bronze_ingot_from_bronze_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.NICKEL_NUGGET.get(), (ItemLike)RailcraftItems.NICKEL_INGOT.get(), "nickel_ingot_from_nickel_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.INVAR_NUGGET.get(), (ItemLike)RailcraftItems.INVAR_INGOT.get(), "invar_ingot_from_invar_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.SILVER_NUGGET.get(), (ItemLike)RailcraftItems.SILVER_INGOT.get(), "silver_ingot_from_silver_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.LEAD_NUGGET.get(), (ItemLike)RailcraftItems.LEAD_INGOT.get(), "lead_ingot_from_lead_nugget");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.STEEL_INGOT.get(), (ItemLike)RailcraftItems.STEEL_BLOCK.get(), "steel_block_from_steel_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.TIN_INGOT.get(), (ItemLike)RailcraftItems.TIN_BLOCK.get(), "tin_block_from_tin_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.ZINC_INGOT.get(), (ItemLike)RailcraftItems.ZINC_BLOCK.get(), "zinc_block_from_zinc_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.BRASS_INGOT.get(), (ItemLike)RailcraftItems.BRASS_BLOCK.get(), "brass_block_from_brass_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.BRONZE_INGOT.get(), (ItemLike)RailcraftItems.BRONZE_BLOCK.get(), "bronze_block_from_bronze_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.NICKEL_INGOT.get(), (ItemLike)RailcraftItems.NICKEL_BLOCK.get(), "nickel_block_from_nickel_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.INVAR_INGOT.get(), (ItemLike)RailcraftItems.INVAR_BLOCK.get(), "invar_block_from_invar_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.SILVER_INGOT.get(), (ItemLike)RailcraftItems.SILVER_BLOCK.get(), "silver_block_from_silver_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.LEAD_INGOT.get(), (ItemLike)RailcraftItems.LEAD_BLOCK.get(), "lead_block_from_lead_ingot");
        RailcraftRecipeProvider.nineBlockStorageRecipes(recipeOutput, (ItemLike)RailcraftItems.COAL_COKE.get(), (ItemLike)RailcraftItems.COAL_COKE_BLOCK.get(), "coal_coke_block_from_coal_coke");
    }

    private static void nineBlockStorageRecipes(RecipeOutput recipeOutput, ItemLike unpacked, ItemLike packed, String packingRecipeName) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)unpacked, (int)9).requires(packed).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)packed), RailcraftRecipeProvider.has((ItemLike)packed)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)packed).pattern("aaa").pattern("aaa").pattern("aaa").define(Character.valueOf('a'), unpacked).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)unpacked), RailcraftRecipeProvider.has((ItemLike)unpacked)).save(recipeOutput, RailcraftConstants.rl(packingRecipeName));
    }

    private void buildIngotsRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.BRONZE_INGOT.get()), (int)4).pattern("ab").pattern("bb").define(Character.valueOf('a'), RailcraftTags.Items.TIN_INGOT).define(Character.valueOf('b'), Tags.Items.INGOTS_COPPER).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.TIN_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.TIN_INGOT)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.COPPER_INGOT), RailcraftRecipeProvider.has((TagKey)Tags.Items.INGOTS_COPPER)).save(recipeOutput, RailcraftConstants.rl("bronze_ingot_crafted_with_ingots"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.BRASS_INGOT.get()), (int)4).pattern("ab").pattern("bb").define(Character.valueOf('a'), RailcraftTags.Items.ZINC_INGOT).define(Character.valueOf('b'), Tags.Items.INGOTS_COPPER).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.ZINC_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.ZINC_INGOT)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.COPPER_INGOT), RailcraftRecipeProvider.has((TagKey)Tags.Items.INGOTS_COPPER)).save(recipeOutput, RailcraftConstants.rl("brass_ingot_crafted_with_ingots"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.INVAR_INGOT.get()), (int)3).pattern("ab").pattern("b ").define(Character.valueOf('a'), RailcraftTags.Items.NICKEL_INGOT).define(Character.valueOf('b'), Tags.Items.INGOTS_IRON).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.NICKEL_INGOT.get())), RailcraftRecipeProvider.has(RailcraftTags.Items.NICKEL_INGOT)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.IRON_INGOT), RailcraftRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(recipeOutput, RailcraftConstants.rl("invar_ingot_crafted_with_ingots"));
    }

    private void buildStrengthenedGlass(RecipeOutput recipeOutput) {
        Map<String, TagKey> ingredients = Map.of("tin", RailcraftTags.Items.TIN_INGOT, "nickel", RailcraftTags.Items.NICKEL_INGOT, "invar", RailcraftTags.Items.INVAR_INGOT, "brass", RailcraftTags.Items.BRASS_INGOT, "iron", Tags.Items.INGOTS_IRON);
        VariantSet<DyeColor, Item, BlockItem> colorItems = RailcraftItems.STRENGTHENED_GLASS;
        TagKey<Item> tagItem = RailcraftTags.Items.STRENGTHENED_GLASS;
        BlockItem result = (BlockItem)colorItems.variantFor(DyeColor.WHITE).get();
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath();
        for (Map.Entry<String, TagKey> ingredient : ingredients.entrySet()) {
            String recipeName = name.substring(name.indexOf(95) + 1) + "_" + ingredient.getKey();
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)6).pattern("aba").pattern("aca").pattern("ada").define(Character.valueOf('a'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('b'), ingredient.getValue()).define(Character.valueOf('c'), (ItemLike)RailcraftItems.SALTPETER_DUST.get()).define(Character.valueOf('d'), (ItemLike)Items.WATER_BUCKET).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.SALTPETER_DUST.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.SALTPETER_DUST.get()))).save(recipeOutput, RailcraftConstants.rl(recipeName));
        }
        RailcraftRecipeProvider.coloredBlockVariant(recipeOutput, colorItems, tagItem);
    }

    private void buildTie(RecipeOutput recipeOutput) {
        RailcraftSpecialRecipeBuilder.special(WoodenTieRecipe::new).save(recipeOutput, RailcraftRecipeProvider.getItemName((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get())));
        RailcraftSpecialRecipeBuilder.special(StoneTieRecipe::new).save(recipeOutput, RailcraftRecipeProvider.getItemName((ItemLike)((ItemLike)RailcraftItems.STONE_TIE.get())));
    }

    private void buildCement(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.BAG_OF_CEMENT.get()), (int)2).pattern("ab").pattern("ba").define(Character.valueOf('a'), (ItemLike)Items.GRAVEL).define(Character.valueOf('b'), (ItemLike)Items.QUARTZ).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.QUARTZ), RailcraftRecipeProvider.has((ItemLike)Items.QUARTZ)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.BAG_OF_CEMENT.get()), (int)2).pattern("ab").pattern("ca").define(Character.valueOf('a'), (ItemLike)Items.GRAVEL).define(Character.valueOf('b'), (ItemLike)Items.QUARTZ).define(Character.valueOf('c'), (ItemLike)RailcraftItems.SLAG.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.SLAG.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.SLAG.get()))).save(recipeOutput, RailcraftConstants.rl("bag_of_cement_slag"));
    }

    private static void tankWall(RecipeOutput recipeOutput, TagKey<Item> ingredientTag, VariantSet<DyeColor, Item, BlockItem> colorItems, TagKey<Item> tagItem) {
        BlockItem result = (BlockItem)colorItems.variantFor(DyeColor.WHITE).get();
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath();
        String ingredient = ingredientTag.equals(RailcraftTags.Items.IRON_PLATE) ? "has_iron_plate" : "has_steel_plate";
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)8).pattern("aa").pattern("aa").define(Character.valueOf('a'), ingredientTag).unlockedBy(ingredient, RailcraftRecipeProvider.has(ingredientTag)).save(recipeOutput, RailcraftConstants.rl(name.substring(name.indexOf(95) + 1)));
        RailcraftRecipeProvider.coloredBlockVariant(recipeOutput, colorItems, tagItem);
    }

    private static void tankValve(RecipeOutput recipeOutput, TagKey<Item> ingredientTag, VariantSet<DyeColor, Item, BlockItem> colorItems, TagKey<Item> tagItem) {
        BlockItem result = (BlockItem)colorItems.variantFor(DyeColor.WHITE).get();
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath();
        String ingredient = ingredientTag.equals(RailcraftTags.Items.IRON_PLATE) ? "has_iron_plate" : "has_steel_plate";
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)8).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('b'), ingredientTag).define(Character.valueOf('c'), (ItemLike)Items.LEVER).unlockedBy(ingredient, RailcraftRecipeProvider.has(ingredientTag)).save(recipeOutput, RailcraftConstants.rl(name.substring(name.indexOf(95) + 1)));
        RailcraftRecipeProvider.coloredBlockVariant(recipeOutput, colorItems, tagItem);
    }

    private static void tankGauge(RecipeOutput recipeOutput, TagKey<Item> ingredientTag, VariantSet<DyeColor, Item, BlockItem> colorItems, TagKey<Item> tagItem) {
        BlockItem result = (BlockItem)colorItems.variantFor(DyeColor.WHITE).get();
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath();
        String ingredient = ingredientTag.equals(RailcraftTags.Items.IRON_PLATE) ? "has_iron_plate" : "has_steel_plate";
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)8).pattern("aba").pattern("bab").pattern("aba").define(Character.valueOf('a'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('b'), ingredientTag).unlockedBy(ingredient, RailcraftRecipeProvider.has(ingredientTag)).save(recipeOutput, RailcraftConstants.rl(name.substring(name.indexOf(95) + 1)));
        RailcraftRecipeProvider.coloredBlockVariant(recipeOutput, colorItems, tagItem);
    }

    private void buildTankBlocks(RecipeOutput recipeOutput) {
        RailcraftRecipeProvider.tankWall(recipeOutput, RailcraftTags.Items.IRON_PLATE, RailcraftItems.IRON_TANK_WALL, RailcraftTags.Items.IRON_TANK_WALL);
        RailcraftRecipeProvider.tankWall(recipeOutput, RailcraftTags.Items.STEEL_PLATE, RailcraftItems.STEEL_TANK_WALL, RailcraftTags.Items.STEEL_TANK_WALL);
        RailcraftRecipeProvider.tankValve(recipeOutput, RailcraftTags.Items.IRON_PLATE, RailcraftItems.IRON_TANK_VALVE, RailcraftTags.Items.IRON_TANK_VALVE);
        RailcraftRecipeProvider.tankValve(recipeOutput, RailcraftTags.Items.STEEL_PLATE, RailcraftItems.STEEL_TANK_VALVE, RailcraftTags.Items.STEEL_TANK_VALVE);
        RailcraftRecipeProvider.tankGauge(recipeOutput, RailcraftTags.Items.IRON_PLATE, RailcraftItems.IRON_TANK_GAUGE, RailcraftTags.Items.IRON_TANK_GAUGE);
        RailcraftRecipeProvider.tankGauge(recipeOutput, RailcraftTags.Items.STEEL_PLATE, RailcraftItems.STEEL_TANK_GAUGE, RailcraftTags.Items.STEEL_TANK_GAUGE);
    }

    private void buildPost(RecipeOutput recipeOutput) {
        RailcraftRecipeProvider.coloredBlockVariant(recipeOutput, RailcraftItems.POST, RailcraftTags.Items.POST, DyeColor.BLACK);
    }

    private void buildDecorativeStone(RecipeOutput recipeOutput) {
        for (DecorativeBlock type : DecorativeBlock.values()) {
            RailcraftRecipeProvider.square2x2(recipeOutput, (Item)RailcraftItems.DECORATIVE_STONE.variantFor(type).get(), (Item)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get(), 4, "_from_%s_stone".formatted(type.getSerializedName()));
            RailcraftRecipeProvider.square2x2(recipeOutput, (Item)RailcraftItems.DECORATIVE_COBBLESTONE.variantFor(type).get(), (Item)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get(), 4, "_from_%s_cobblestone".formatted(type.getSerializedName()));
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RailcraftItems.DECORATIVE_STONE.variantFor(type).get())}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get())).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_STONE.variantFor(type).get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_STONE.variantFor(type).get()))).save(recipeOutput, RailcraftConstants.rl("polished_%s_stone_from_%s_stone_in_stonecutter".formatted(type.getSerializedName(), type.getSerializedName())));
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RailcraftItems.DECORATIVE_COBBLESTONE.variantFor(type).get())}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get())).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_COBBLESTONE.variantFor(type).get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_COBBLESTONE.variantFor(type).get()))).save(recipeOutput, RailcraftConstants.rl("polished_%s_stone_from_%s_cobblestone_in_stonecutter".formatted(type.getSerializedName(), type.getSerializedName())));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.CHISELED_DECORATIVE_STONE.variantFor(type).get()), (int)8).pattern("aaa").pattern("a a").pattern("aaa").define(Character.valueOf('a'), (ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get()))).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ETCHED_DECORATIVE_STONE.variantFor(type).get()), (int)8).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get()).define(Character.valueOf('b'), (ItemLike)Items.GUNPOWDER).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get()))).save(recipeOutput);
            RailcraftRecipeProvider.square2x2(recipeOutput, (Item)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get(), (Item)RailcraftItems.DECORATIVE_BRICKS.variantFor(type).get(), 4, "");
            RailcraftRecipeProvider.stairBuilder((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_BRICK_STAIRS.variantFor(type).get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.DECORATIVE_BRICKS.variantFor(type).get()})).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_BRICKS.variantFor(type).get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_BRICKS.variantFor(type).get()))).save(recipeOutput);
            RailcraftRecipeProvider.slab((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.DECORATIVE_BRICK_SLAB.variantFor(type).get()), (ItemLike)((ItemLike)RailcraftItems.DECORATIVE_BRICKS.variantFor(type).get()));
            RailcraftRecipeProvider.square2x2(recipeOutput, (Item)RailcraftItems.DECORATIVE_BRICKS.variantFor(type).get(), (Item)RailcraftItems.DECORATIVE_PAVER.variantFor(type).get(), 4, "");
            RailcraftRecipeProvider.stairBuilder((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_PAVER_STAIRS.variantFor(type).get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.DECORATIVE_PAVER.variantFor(type).get()})).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_PAVER.variantFor(type).get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_PAVER.variantFor(type).get()))).save(recipeOutput);
            RailcraftRecipeProvider.slab((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.DECORATIVE_PAVER_SLAB.variantFor(type).get()), (ItemLike)((ItemLike)RailcraftItems.DECORATIVE_PAVER.variantFor(type).get()));
        }
    }

    private void buildBattery(RecipeOutput recipeOutput) {
        RailcraftRecipeProvider.battery(recipeOutput, (Item)RailcraftItems.NICKEL_ZINC_BATTERY.get(), (Item)RailcraftItems.NICKEL_ELECTRODE.get(), (Item)RailcraftItems.ZINC_ELECTRODE.get());
        RailcraftRecipeProvider.battery(recipeOutput, (Item)RailcraftItems.NICKEL_IRON_BATTERY.get(), (Item)RailcraftItems.NICKEL_ELECTRODE.get(), (Item)RailcraftItems.IRON_ELECTRODE.get());
        RailcraftRecipeProvider.battery(recipeOutput, (Item)RailcraftItems.ZINC_SILVER_BATTERY.get(), (Item)RailcraftItems.ZINC_ELECTRODE.get(), (Item)RailcraftItems.SILVER_ELECTRODE.get());
        RailcraftRecipeProvider.battery(recipeOutput, (Item)RailcraftItems.ZINC_CARBON_BATTERY.get(), (Item)RailcraftItems.ZINC_ELECTRODE.get(), (Item)RailcraftItems.CARBON_ELECTRODE.get());
    }

    private static void battery(RecipeOutput recipeOutput, Item result, Item left, Item right) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("aba").pattern("cde").pattern("cfe").define(Character.valueOf('a'), (ItemLike)RailcraftItems.CHARGE_TERMINAL.get()).define(Character.valueOf('b'), (ItemLike)RailcraftItems.CHARGE_SPOOL_MEDIUM.get()).define(Character.valueOf('c'), (ItemLike)left).define(Character.valueOf('d'), RailcraftTags.Items.SALTPETER_DUST).define(Character.valueOf('e'), (ItemLike)right).define(Character.valueOf('f'), (ItemLike)Items.WATER_BUCKET).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)left), RailcraftRecipeProvider.has((ItemLike)left)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)right), RailcraftRecipeProvider.has((ItemLike)right)).save(recipeOutput);
    }

    private void buildFrame(RecipeOutput recipeOutput) {
        this.frame(6, RailcraftTags.Items.IRON_PLATE, "_iron_plate", recipeOutput);
        this.frame(6, RailcraftTags.Items.BRONZE_PLATE, "_bronze_plate", recipeOutput);
        this.frame(6, RailcraftTags.Items.BRASS_PLATE, "_brass_plate", recipeOutput);
        this.frame(10, RailcraftTags.Items.STEEL_PLATE, "_steel_plate", recipeOutput);
    }

    private void frame(int count, TagKey<Item> tag, String suffix, RecipeOutput recipeOutput) {
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)((ItemLike)RailcraftItems.FRAME_BLOCK.get())).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.FRAME_BLOCK.get()), (int)count).pattern("aaa").pattern("b b").pattern("bbb").define(Character.valueOf('a'), tag).define(Character.valueOf('b'), (ItemLike)RailcraftItems.REBAR.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.REBAR.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.REBAR.get()))).save(recipeOutput, RailcraftConstants.rl(name + suffix));
    }

    private void buildDetectors(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ADVANCED_DETECTOR.get())).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.AGE_DETECTOR.get())).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.DARK_OAK_LOG).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.SPRUCE_LOG), RailcraftRecipeProvider.has((ItemLike)Items.SPRUCE_LOG)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ANIMAL_DETECTOR.get())).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.OAK_LOG).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.SPRUCE_LOG), RailcraftRecipeProvider.has((ItemLike)Items.SPRUCE_LOG)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ANY_DETECTOR.get())).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.STONE).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.STONE), RailcraftRecipeProvider.has((ItemLike)Items.STONE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.EMPTY_DETECTOR.get())).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.STONE_BRICKS).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.STONE_BRICKS), RailcraftRecipeProvider.has((ItemLike)Items.STONE_BRICKS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ITEM_DETECTOR.get())).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.STRIPPED_ACACIA_WOOD).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.STRIPPED_ACACIA_WOOD), RailcraftRecipeProvider.has((ItemLike)Items.STRIPPED_ACACIA_WOOD)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.LOCOMOTIVE_DETECTOR.get())).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)RailcraftItems.BLAST_FURNACE_BRICKS.get()).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.BLAST_FURNACE_BRICKS.get())), RailcraftRecipeProvider.has((ItemLike)((ItemLike)RailcraftItems.BLAST_FURNACE_BRICKS.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.MOB_DETECTOR.get())).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.MOSSY_COBBLESTONE).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MOSSY_COBBLESTONE), RailcraftRecipeProvider.has((ItemLike)Items.MOSSY_COBBLESTONE)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.PLAYER_DETECTOR.get())).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.STONE_SLAB).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.STONE_SLAB), RailcraftRecipeProvider.has((ItemLike)Items.STONE_SLAB)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.ROUTING_DETECTOR.get())).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.CHISELED_QUARTZ_BLOCK).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.CHISELED_QUARTZ_BLOCK), RailcraftRecipeProvider.has((ItemLike)Items.CHISELED_QUARTZ_BLOCK)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.SHEEP_DETECTOR.get())).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), ItemTags.WOOL).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.WHITE_WOOL), RailcraftRecipeProvider.has((ItemLike)Items.WHITE_WOOL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TANK_DETECTOR.get())).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.BRICK).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.BRICK), RailcraftRecipeProvider.has((ItemLike)Items.BRICK)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.TRAIN_DETECTOR.get())).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.NETHER_BRICK).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.NETHER_BRICK), RailcraftRecipeProvider.has((ItemLike)Items.NETHER_BRICK)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.VILLAGER_DETECTOR.get())).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.LEATHER).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.LEATHER), RailcraftRecipeProvider.has((ItemLike)Items.LEATHER)).save(recipeOutput);
    }

    private static void buildWorldSpike(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.WORLD_SPIKE.get())).pattern("gog").pattern("dpd").pattern("gog").define(Character.valueOf('d'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('p'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('o'), (ItemLike)Items.OBSIDIAN).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.ENDER_PEARL), RailcraftRecipeProvider.has((ItemLike)Items.ENDER_PEARL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.PERSONAL_WORLD_SPIKE.get())).pattern("gog").pattern("dpd").pattern("gog").define(Character.valueOf('d'), Tags.Items.GEMS_EMERALD).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('p'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('o'), (ItemLike)Items.OBSIDIAN).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.ENDER_PEARL), RailcraftRecipeProvider.has((ItemLike)Items.ENDER_PEARL)).save(recipeOutput);
    }

    private static void square2x2(RecipeOutput recipeOutput, TagKey<Item> ingredient, Item result, int quantity, String suffix) {
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)quantity).pattern("aa").pattern("aa").define(Character.valueOf('a'), ingredient).unlockedBy("has_material", RailcraftRecipeProvider.has(ingredient)).save(recipeOutput, RailcraftConstants.rl(name + suffix));
    }

    private static void square2x2(RecipeOutput recipeOutput, Item ingredient, Item result, int quantity, String suffix) {
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)quantity).pattern("aa").pattern("aa").define(Character.valueOf('a'), (ItemLike)ingredient).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)ingredient), RailcraftRecipeProvider.has((ItemLike)ingredient)).save(recipeOutput, RailcraftConstants.rl(name + suffix));
    }

    private static void coloredBlockVariant(RecipeOutput recipeOutput, VariantSet<DyeColor, Item, BlockItem> colorItems, TagKey<Item> tagItem) {
        RailcraftRecipeProvider.coloredBlockVariant(recipeOutput, colorItems, tagItem, DyeColor.WHITE);
    }

    private static void coloredBlockVariant(RecipeOutput recipeOutput, VariantSet<DyeColor, Item, BlockItem> colorItems, TagKey<Item> tagItem, DyeColor baseColor) {
        BlockItem base = (BlockItem)colorItems.variantFor(baseColor).get();
        for (DyeColor dyeColor : DyeColor.values()) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)colorItems.variantFor(dyeColor).get()), (int)8).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), tagItem).define(Character.valueOf('b'), (ItemLike)DyeItem.byColor((DyeColor)dyeColor)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)base), RailcraftRecipeProvider.has((ItemLike)base)).save(recipeOutput);
        }
    }
}

