/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.emi;

import dev.emi.emi.api.neoforge.NeoForgeEmiStack;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.integrations.emi.RailcraftEmiPlugin;
import mods.railcraft.world.item.crafting.CokeOvenRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.fluids.FluidStack;

public class CokeOvenEmiRecipe
extends BasicEmiRecipe {
    private static final int WIDTH = 124;
    private static final int HEIGHT = 49;
    private static final ResourceLocation BACKGROUND = RailcraftConstants.rl("textures/gui/container/coke_oven.png");
    private final CokeOvenRecipe recipe;

    public CokeOvenEmiRecipe(RecipeHolder<CokeOvenRecipe> recipe) {
        super(RailcraftEmiPlugin.COKING_CATEGORY, recipe.id(), 124, 49);
        this.recipe = (CokeOvenRecipe)recipe.value();
        this.inputs.add(EmiIngredient.of((Ingredient)((Ingredient)this.recipe.getIngredients().getFirst())));
        ClientLevel level = Minecraft.getInstance().level;
        this.outputs.add(EmiStack.of((ItemStack)this.recipe.getResultItem((HolderLookup.Provider)level.registryAccess())));
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0, this.width, this.height, 15, 23);
        widgets.addFillingArrow(18, 20, 10000).tooltip((x, y) -> {
            int cookTime = this.recipe.getCookingTime();
            if (cookTime > 0) {
                int cookTimeSeconds = cookTime / 20;
                MutableComponent timeString = Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
                return List.of(EmiTooltipComponents.of((Component)timeString));
            }
            return List.of(EmiTooltipComponents.of((Component)Component.empty()));
        });
        widgets.addAnimatedTexture(EmiTexture.FULL_FLAME, 1, 3, 10000, false, true, true);
        widgets.addSlot((EmiIngredient)this.inputs.getFirst(), 0, 19);
        widgets.addSlot((EmiIngredient)this.outputs.getFirst(), 42, 15).large(true).recipeContext((EmiRecipe)this);
        EmiStack fluid = NeoForgeEmiStack.of((FluidStack)this.recipe.getCreosote());
        widgets.addTank((EmiIngredient)fluid, 74, 0, 50, 49, 10000).drawBack(false).recipeContext((EmiRecipe)this);
    }
}

