/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jade;

import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;

class LocomotiveComponent
implements IEntityComponentProvider {
    LocomotiveComponent() {
    }

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        Entity entity = accessor.getEntity();
        if (entity instanceof Locomotive) {
            Locomotive locomotive = (Locomotive)entity;
            tooltip.add((Component)Component.translatable((String)Translations.LookingAt.MODE).append(locomotive.getMode().getDisplayName()));
            tooltip.add((Component)Component.translatable((String)Translations.LookingAt.SPEED, (Object[])new Object[]{locomotive.getSpeed().getLevel()}));
            String reverse = locomotive.isReverse() ? Translations.LookingAt.YES : Translations.LookingAt.NO;
            tooltip.add((Component)Component.translatable((String)Translations.LookingAt.REVERSE).append((Component)Component.translatable((String)reverse)));
            tooltip.remove(JadeIds.UNIVERSAL_ITEM_STORAGE);
        }
    }

    public int getDefaultPriority() {
        return 10000;
    }

    public ResourceLocation getUid() {
        return RailcraftConstants.rl("locomotive");
    }
}

