/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import mods.railcraft.RailcraftConfig;
import mods.railcraft.datamaps.FluidHeat;
import mods.railcraft.datamaps.RailcraftDataMaps;
import net.neoforged.neoforge.fluids.FluidStack;

public final class FuelUtil {
    private FuelUtil() {
    }

    public static float getFuelValue(FluidStack fluid) {
        FluidHeat fluidHeat = (FluidHeat)fluid.getFluidHolder().getData(RailcraftDataMaps.FLUID_HEAT);
        if (fluidHeat == null) {
            return 0.0f;
        }
        float fuelMultiplier = ((Double)RailcraftConfig.SERVER.fuelMultiplier.get()).floatValue();
        return fuelMultiplier * (float)fluidHeat.heatValuePerBucket();
    }

    public static float getFuelValueForSize(FluidStack fluid) {
        return FuelUtil.getFuelValue(fluid) * (float)fluid.getAmount() / 1000.0f;
    }
}

