/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public sealed interface VariantSet<K extends Enum<K>, R, V extends R> {
    public DeferredHolder<R, ? extends V> variantFor(K var1);

    public Collection<DeferredHolder<R, ? extends V>> variants();

    default public Stream<? extends V> boundVariants() {
        return this.variants().stream().map(DeferredHolder::get);
    }

    public void forEach(BiConsumer<K, DeferredHolder<R, ? extends V>> var1);

    public static <K extends Enum<K>, R, V extends R> VariantSet<K, R, V> of(Class<K> keyType, DeferredRegister<R> deferredRegister, String nameTemplate, Function<K, V> factory) {
        EnumMap<Enum, DeferredHolder> variants = new EnumMap<Enum, DeferredHolder>(keyType);
        for (Enum key : (Enum[])keyType.getEnumConstants()) {
            variants.put(key, deferredRegister.register(String.format(nameTemplate, ((StringRepresentable)key).getSerializedName()), () -> factory.apply(key)));
        }
        return new MappedVariantSet(variants);
    }

    public static <K extends Enum<K>, R, V extends R, SR, SV extends SR> VariantSet<K, R, V> ofMapped(Class<K> keyType, DeferredRegister<R> deferredRegister, VariantSet<K, SR, SV> source, Function<? super SV, ? extends V> mapper) {
        EnumMap variants = new EnumMap(keyType);
        source.forEach((key, value) -> variants.put((Object)key, deferredRegister.register(value.getId().getPath(), () -> mapper.apply((Object)value.get()))));
        return new MappedVariantSet(variants);
    }

    public record MappedVariantSet<K extends Enum<K>, R, V extends R>(Map<K, DeferredHolder<R, ? extends V>> variantsByKey) implements VariantSet<K, R, V>
    {
        public MappedVariantSet(Map<K, DeferredHolder<R, ? extends V>> variantsByKey) {
            this.variantsByKey = ImmutableMap.copyOf(variantsByKey);
        }

        @Override
        public DeferredHolder<R, ? extends V> variantFor(K key) {
            return this.variantsByKey.get(key);
        }

        @Override
        public Collection<DeferredHolder<R, ? extends V>> variants() {
            return this.variantsByKey.values();
        }

        @Override
        public void forEach(BiConsumer<K, DeferredHolder<R, ? extends V>> action) {
            this.variantsByKey.forEach(action);
        }
    }
}

