/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.inventory;

import mods.railcraft.world.inventory.RailcraftMenu;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.item.GoldenTicketItem;
import mods.railcraft.world.level.block.entity.track.RoutingTrackBlockEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RoutingTrackMenu
extends RailcraftMenu {
    private final RoutingTrackBlockEntity blockEntity;

    public RoutingTrackMenu(int id, Inventory inventory, final RoutingTrackBlockEntity blockEntity) {
        super((MenuType)RailcraftMenuTypes.ROUTING_TRACK.get(), id, inventory.player, blockEntity::isStillValid);
        this.blockEntity = blockEntity;
        Slot goldenTicketSlot = new Slot(this, blockEntity, 0, 44, 24){

            public boolean mayPlace(ItemStack stack) {
                return GoldenTicketItem.FILTER.test(stack) && stack.getCount() == 1;
            }

            public boolean mayPickup(Player player) {
                return blockEntity.canAccess(player.getGameProfile());
            }

            public boolean allowModification(Player player) {
                if (blockEntity.canAccess(player.getGameProfile())) {
                    return super.allowModification(player);
                }
                return false;
            }
        };
        this.addSlot(goldenTicketSlot);
        this.addInventorySlots(inventory, 140);
    }

    public RoutingTrackBlockEntity getRoutingBlockEntity() {
        return this.blockEntity;
    }
}

